package org.molap.series

import kotlin.reflect.KClass

interface Series<K, V> {
    val name: Any?
    val type: KClass<out Any>

    operator fun get(key: K): V
    fun getKey(i: Int): K
    fun size(): Int
    fun getAddress(key: K): Int
    fun keys(): Iterable<K>?
//    fun <L> reindex(vararg keys: L): Series<L, V>?
    fun count(): Int?
    fun sum(): Double?
    fun mean(): Double?
    fun meanAbsoluteDeviation(): Double?
    fun median(): V
    fun min(): V
    fun max(): V
    fun countUnique(): Int?
    fun indexMin(): K
    fun indexMax(): K
//    fun head(count: Int): Series<K, V>?
//    fun tail(count: Int): Series<K, V>?
//    fun add(other: Series<K, V>?): Series<K, Double?>?
//    fun subtract(other: Series<K, V>?): Series<K, Double?>?
//    fun multiply(other: Series<K, V>?): Series<K, Double?>?
//    fun divide(other: Series<K, V>?): Series<K, Double?>?
//    fun pow(exponent: Double?): Series<K, Double?>?
    fun print()
}
