/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.collection.RandomAccessIterable
import com.macrofocus.common.collection.TIntSet
import com.macrofocus.common.selection.MutableSelection

/**
 * Created by luc on 06.04.17.
 */
interface BinningDimension<Row, Bin> : Dimension<Row> {
    val bins: RandomAccessIterable<Bin>?
    val activeBins: RandomAccessIterable<Bin>?
    val selection: MutableSelection<Row>?
    val filterExact: MutableSelection<Bin>?
    fun filterExact(vararg bins: Bin)
    fun filterExactIterable(bins: Iterable<Bin>)
    var inverseFilter: Boolean
    fun getBins(row: Row): Iterable<Bin>?
    fun getRows(bin: Bin): Iterable<Row>?
    fun getGroup(reducer: Reducer<Row, Bin>): Group<Row, Bin>
    fun getDensity(bin: Bin): Double
    fun getActiveDensity(bin: Bin): Double
    fun getFilterDensity(bin: Bin): Double
    fun getSelectionDensity(bin: Bin): Double
    val maxDensity: Double
    val maxActiveDensity: Double
    val sumDensity: Double
    val sumActiveDensity: Double
    val activeIndicesUsingArrays: IntArray?
    val activeIndicesUsingHashSet: TIntSet?

    interface BinningStrategy<Row, Bin> {
        fun isBinnable(row: Row): Boolean
    }
}