package org.molap.csv

import org.molap.dataframe.DataFrame
import org.molap.exporter.DataFrameExporter
import org.molap.exporter.DelimitedDataFrameWriter
import org.molap.exporter.OutputStreamWriterDataFrameOutput
import java.io.File
import java.io.OutputStream
import java.io.OutputStreamWriter

fun <R,C,V> DataFrame<R, C, V>.writeCSV(file: File) {
    val outputStream = file.outputStream()
    writeCSV(outputStream)
    outputStream.flush()
    outputStream.close()
}

fun <R,C,V> DataFrame<R, C, V>.writeCSV(outputStream: OutputStream) {
    val delimiter = ","
    val newLine = "\n"
    DataFrameExporter.export(this, DelimitedDataFrameWriter(OutputStreamWriterDataFrameOutput(OutputStreamWriter(outputStream)), delimiter, newLine))
}