package org.molap.json

import org.molap.dataframe.DataFrame
import org.molap.dataframe.JsonDataFrame
import java.io.File
import java.io.InputStream

fun DataFrame.Companion.readJson(json: String): DataFrame<Int, String, Any?> {
    return JsonDataFrame(json)
}

fun DataFrame.Companion.readJson(file: File): DataFrame<Int, String, Any?> {
    val inputStream = file.inputStream()
    val dataFrame = readJson(inputStream)
    inputStream.close()
    return dataFrame
}

fun DataFrame.Companion.readJson(inputStream: InputStream): DataFrame<Int, String, Any?> {
    return JsonDataFrame(inputStream.bufferedReader().readText())
}