package org.molap.swing

import org.molap.dataframe.AbstractDataFrame
import org.molap.dataframe.DataFrameEvent
import org.molap.dataframe.MutableDataFrame
import org.molap.index.DefaultUniqueIndex
import org.molap.index.IntegerRangeUniqueIndex
import org.molap.index.MultiKey
import org.molap.index.UniqueIndex
import org.molap.series.AbstractSeries
import org.molap.series.Series
import javax.swing.table.TableModel
import kotlin.reflect.KClass

class TableModelDataFrame(val tableModel: TableModel) : AbstractDataFrame<Int, String?, Any?>(),
    MutableDataFrame<Int, String?, Any?> {
    override val rowIndex: UniqueIndex<Int> by lazy { IntegerRangeUniqueIndex(0, tableModel.rowCount - 1) }

    override val columnIndex: UniqueIndex<String?> by lazy {
        val names = arrayOfNulls<String>(tableModel.columnCount)
        for (c in 0 until tableModel.columnCount) {
            names[c] = tableModel.getColumnName(c)
        }
        DefaultUniqueIndex<String?>(UniqueIndex.Duplicate.UseFirstWarn, *names)
    }

    override fun getRowClass(row: Int): KClass<Any>? {
        return null
    }

    override fun getColumnClass(column: String?): KClass<out Any> {
        val columnClass = tableModel.getColumnClass(columnIndex.getAddress(column))!!
        return columnClass.kotlin
    }

    override fun getValueAt(row: Int, column: String?): Any {
        return tableModel.getValueAt(row, columnIndex.getAddress(column))
    }

    override fun setValueAt(row: Int, column: String?, value: Any?) {
        tableModel.setValueAt(value, row, columnIndex.getAddress(column))
    }

    fun getRow(row: Int?): Series<String, *>? {
        return null
    }

    override fun getColumn(column: String?): Series<Int, Any?>? {
        return ColumnSeries(column)
    }

    override fun rows(): Iterable<Int> {
        return rowIndex.keys()
    }

    override fun columns(): Iterable<String?> {
        return columnIndex.keys()
    }

    override fun getRowKey(index: Int): Int {
        return rowIndex.getKey(index)
    }

    override fun getColumnKey(index: Int): String {
        return columnIndex.getKey(index)!!
    }

    override fun getRowAddress(row: Int): Int {
        return rowIndex.getAddress(row)
    }

    override fun getColumnAddress(column: String?): Int {
        return columnIndex.getAddress(column!!)
    }

    override val rowCount: Int
        get() = tableModel.rowCount
    override val columnCount: Int
        get() = tableModel.columnCount

    override fun reindexRowsUsingColumns(vararg rows: String?): MutableDataFrame<MultiKey?, String?, Any?>? {
        TODO("Not yet implemented")
    }

    override fun reindexRowsUsingColumn(column: String?): MutableDataFrame<Any?, String?, Any?>? {
        TODO("Not yet implemented")
    }

    private inner class ColumnSeries constructor(column: String?) : AbstractSeries<Int, Any?>() {
        private val column: String?
        override val name: Any?
            get() = column
        override val type: KClass<out Any>
            get() = getColumnClass(column)

        override fun get(key: Int): Any {
            return getValueAt(key, column)
        }

        override fun getKey(i: Int): Int {
            return getRowKey(i)
        }

        override fun size(): Int {
            return rowCount
        }

        override fun getAddress(key: Int): Int {
            return getRowAddress(key)
        }

        override fun keys(): Iterable<Int> {
            return rows()
        }

        init {
            assert(column != null)
            this.column = column
        }
    }

    init {
        tableModel.addTableModelListener {
//            rowIndex = null
//            columnIndex = null
            notifyDataFrameChanged(DataFrameEvent<Int, String?>(emptyList(), emptyList(), true))
        }
    }
}
