/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.aggregation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.AbstractAggregation;
import org.molap.aggregates.aggregation.AggregateSeriesFunction;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;
import org.molap.series.AbstractTimeSeries;
import org.molap.series.Series;
import org.molap.series.TimeSeries;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00020\u0001:\u0002\u0016\u0017B'\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/molap/aggregates/aggregation/TimeSeriesAggregation;", "Lorg/molap/aggregates/aggregation/AbstractAggregation;", "Lorg/molap/series/TimeSeries;", "time", "Lorg/molap/series/Series;", "column", "<init>", "(Lorg/molap/series/Series;Lorg/molap/series/Series;)V", "func", "Lorg/molap/aggregates/aggregation/AggregateSeriesFunction;", "type", "Lkotlin/reflect/KClass;", "", "getType", "()Lkotlin/reflect/KClass;", "compute", "cuboid", "Lorg/molap/aggregates/cuboid/Cuboid;", "group", "Lorg/molap/aggregates/cube/Group;", "toString", "", "TimeSeriesAggregateSeriesFunction", "DataFrameTimeSeries", "molap"})
public final class TimeSeriesAggregation
extends AbstractAggregation<TimeSeries<?, ?>> {
    @NotNull
    private final Series<?, ?> time;
    @NotNull
    private final Series<?, ?> column;
    @NotNull
    private final AggregateSeriesFunction<TimeSeries<?, ?>> func;

    public TimeSeriesAggregation(@NotNull Series<?, ?> time, @NotNull Series<?, ?> column) {
        Intrinsics.checkNotNullParameter(time, (String)"time");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.time = time;
        this.column = column;
        this.func = new TimeSeriesAggregateSeriesFunction(time, column);
    }

    @Override
    @NotNull
    public KClass<Object> getType() {
        return Reflection.getOrCreateKotlinClass(TimeSeries.class);
    }

    @Override
    @NotNull
    public TimeSeries<?, ?> compute(@Nullable Cuboid cuboid, @Nullable Group group) {
        Cuboid cuboid2 = cuboid;
        Intrinsics.checkNotNull((Object)cuboid2);
        TimeSeries<?, ?> timeSeries = cuboid2.getAggregate(group, this.func);
        Intrinsics.checkNotNull(timeSeries);
        return timeSeries;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.column.getName());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B=\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\"\u001a\u00028\u00022\u0006\u0010\u0016\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020&H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020&H\u0016J\u0015\u0010)\u001a\u00020&2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\b\u0010,\u001a\u00020-H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006."}, d2={"Lorg/molap/aggregates/aggregation/TimeSeriesAggregation$DataFrameTimeSeries;", "R", "C", "V", "Lorg/molap/series/AbstractTimeSeries;", "Lorg/molap/series/TimeSeries;", "time", "Lorg/molap/series/Series;", "column", "rows", "", "<init>", "(Lorg/molap/series/Series;Lorg/molap/series/Series;Ljava/lang/Iterable;)V", "Lorg/molap/index/UniqueIndex;", "value", "", "minTime", "getMinTime", "()J", "maxTime", "getMaxTime", "getAbsoluteTime", "key", "(Ljava/lang/Object;)J", "getRelativeTime", "getSequantialTime", "name", "", "getName", "()Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getKey", "i", "", "(I)Ljava/lang/Object;", "size", "getAddress", "(Ljava/lang/Object;)I", "keys", "toString", "", "molap"})
    public static final class DataFrameTimeSeries<R, C, V>
    extends AbstractTimeSeries<R, V>
    implements TimeSeries<R, V> {
        @NotNull
        private final Series<R, V> time;
        @NotNull
        private final Series<R, V> column;
        @NotNull
        private final UniqueIndex<R> rows;
        private long minTime;
        private long maxTime;

        public DataFrameTimeSeries(@NotNull Series<R, V> time, @NotNull Series<R, V> column, @NotNull Iterable<? extends R> rows) {
            Intrinsics.checkNotNullParameter(time, (String)"time");
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Intrinsics.checkNotNullParameter(rows, (String)"rows");
            this.time = time;
            this.column = column;
            this.rows = new DefaultUniqueIndex<R>(rows, true);
            for (R row : rows) {
                long t = this.getAbsoluteTime(row);
                if (t > this.getMaxTime()) {
                    this.maxTime = t;
                }
                if (this.getMinTime() != 0L && t >= this.getMinTime()) continue;
                this.minTime = t;
            }
        }

        @Override
        public long getMinTime() {
            return this.minTime;
        }

        @Override
        public long getMaxTime() {
            return this.maxTime;
        }

        @Override
        public long getAbsoluteTime(R key) {
            long l;
            V v = this.time.get(key);
            if (v instanceof Instant) {
                l = ((Instant)v).toEpochMilliseconds();
            } else if (v instanceof LocalDateTime) {
                l = TimeZoneKt.toInstant((LocalDateTime)((LocalDateTime)v), (TimeZone)TimeZone.Companion.currentSystemDefault()).toEpochMilliseconds();
            } else if (v instanceof LocalDate) {
                l = TimeZoneKt.atStartOfDayIn((LocalDate)((LocalDate)v), (TimeZone)TimeZone.Companion.currentSystemDefault()).toEpochMilliseconds();
            } else {
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Number");
                l = ((Number)v).longValue();
            }
            return l;
        }

        @Override
        public long getRelativeTime(R key) {
            return this.getAbsoluteTime(key) - this.getMinTime();
        }

        @Override
        public long getSequantialTime(R key) {
            return this.rows.getAddress(key);
        }

        @Override
        @Nullable
        public Object getName() {
            return this.column.getName();
        }

        @Override
        @NotNull
        public KClass<? extends Object> getType() {
            return this.column.getType();
        }

        @Override
        public V get(R key) {
            return this.column.get(key);
        }

        @Override
        public R getKey(int i) {
            return (R)this.rows.getKey(i);
        }

        @Override
        public int size() {
            return this.rows.getSize();
        }

        @Override
        public int getAddress(R key) {
            return this.rows.getAddress(key);
        }

        @Override
        @NotNull
        public Iterable<R> keys() {
            return this.rows.keys();
        }

        @Override
        @NotNull
        public String toString() {
            return "DataFrameTimeSeries{time=" + this.time + ", column=" + this.column + "}";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001B'\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\fH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u0013\u001a\u00020\u00122\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\u0015\"\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/molap/aggregates/aggregation/TimeSeriesAggregation$TimeSeriesAggregateSeriesFunction;", "Lorg/molap/aggregates/aggregation/AggregateSeriesFunction;", "Lorg/molap/series/TimeSeries;", "time", "Lorg/molap/series/Series;", "column", "<init>", "(Lorg/molap/series/Series;Lorg/molap/series/Series;)V", "aggregate", "cuboid", "Lorg/molap/aggregates/cuboid/Cuboid;", "rows", "", "", "equals", "", "o", "hashCode", "", "hash", "values", "", "([Ljava/lang/Object;)I", "molap"})
    @SourceDebugExtension(value={"SMAP\nTimeSeriesAggregation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeSeriesAggregation.kt\norg/molap/aggregates/aggregation/TimeSeriesAggregation$TimeSeriesAggregateSeriesFunction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,149:1\n12883#2,3:150\n*S KotlinDebug\n*F\n+ 1 TimeSeriesAggregation.kt\norg/molap/aggregates/aggregation/TimeSeriesAggregation$TimeSeriesAggregateSeriesFunction\n*L\n54#1:150,3\n*E\n"})
    private static final class TimeSeriesAggregateSeriesFunction
    implements AggregateSeriesFunction<TimeSeries<?, ?>> {
        @NotNull
        private final Series<?, ?> time;
        @NotNull
        private final Series<?, ?> column;

        public TimeSeriesAggregateSeriesFunction(@NotNull Series<?, ?> time, @NotNull Series<?, ?> column) {
            Intrinsics.checkNotNullParameter(time, (String)"time");
            Intrinsics.checkNotNullParameter(column, (String)"column");
            this.time = time;
            this.column = column;
        }

        @Override
        @NotNull
        public TimeSeries<?, ?> aggregate(@NotNull Cuboid cuboid, @Nullable Iterable<? extends Object> rows) {
            Intrinsics.checkNotNullParameter((Object)cuboid, (String)"cuboid");
            Series<?, ?> series = this.time;
            Intrinsics.checkNotNull(series, (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Any?, kotlin.Any?>");
            Series<?, ?> series2 = this.column;
            Intrinsics.checkNotNull(series2, (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Any?, kotlin.Any?>");
            Iterable<? extends Object> iterable = rows;
            Intrinsics.checkNotNull(iterable);
            return new DataFrameTimeSeries(series, series2, iterable);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesAggregateSeriesFunction that = (TimeSeriesAggregateSeriesFunction)o;
            return Intrinsics.areEqual(this.time, that.time) && Intrinsics.areEqual(this.column, that.column);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.time, this.column};
            return this.hash(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        public final int hash(Object ... values) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            Object[] objectArray = values;
            int initial$iv = 1;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            int n = ((void)$this$fold$iv).length;
            for (int i = 0; i < n; ++i) {
                void value;
                void element$iv;
                void var9_9 = element$iv = $this$fold$iv[i];
                int acc = accumulator$iv;
                boolean bl = false;
                void v0 = value;
                accumulator$iv = 31 * acc + (v0 != null ? v0.hashCode() : 0);
            }
            return accumulator$iv;
        }
    }
}

