/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.cuboid;

import com.macrofocus.common.collection.CollectionFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.AggregateSeriesFunction;
import org.molap.aggregates.cube.Cube;
import org.molap.aggregates.cube.DistributiveStatistics;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cube.UnivariateStatistics;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.series.Series;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002)*B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0014J>\u0010\u001a\u001a\u0004\u0018\u00010\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001e2\u0010\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010 H\u0016J.\u0010!\u001a\u0004\u0018\u00010\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u001eH\u0016J/\u0010\"\u001a\u0004\u0018\u0001H#\"\u0004\b\u0000\u0010#2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u0002H#\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&J4\u0010'\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010(2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u0017\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/molap/aggregates/cuboid/AbstractCuboid;", "Lorg/molap/aggregates/cuboid/Cuboid;", "cube", "Lorg/molap/aggregates/cube/Cube;", "<init>", "(Lorg/molap/aggregates/cube/Cube;)V", "getCube", "()Lorg/molap/aggregates/cube/Cube;", "isDirty", "", "()Z", "setDirty", "(Z)V", "distributiveStatisticsCache", "", "Lorg/molap/aggregates/cuboid/AbstractCuboid$GroupColumn;", "Lorg/molap/aggregates/cube/DistributiveStatistics;", "univariateStatisticsCache", "Lorg/molap/aggregates/cube/UnivariateStatistics;", "aggregateCache", "Lorg/molap/aggregates/cuboid/AbstractCuboid$GroupAggregation;", "", "distinctCache", "", "build", "", "getDistributiveStatistics", "group", "Lorg/molap/aggregates/cube/Group;", "column", "Lorg/molap/series/Series;", "rowExcluder", "Lorg/molap/aggregates/cube/DistributiveStatistics$RowFilter;", "getUnivariateStatistics", "getAggregate", "T", "func", "Lorg/molap/aggregates/aggregation/AggregateSeriesFunction;", "(Lorg/molap/aggregates/cube/Group;Lorg/molap/aggregates/aggregation/AggregateSeriesFunction;)Ljava/lang/Object;", "getDistinct", "", "GroupColumn", "GroupAggregation", "molap"})
public abstract class AbstractCuboid
implements Cuboid {
    @NotNull
    private final Cube cube;
    private boolean isDirty;
    @Nullable
    private Map<GroupColumn, DistributiveStatistics> distributiveStatisticsCache;
    @Nullable
    private Map<GroupColumn, UnivariateStatistics> univariateStatisticsCache;
    @Nullable
    private Map<GroupAggregation, Object> aggregateCache;
    @Nullable
    private Map<GroupColumn, Set<Object>> distinctCache;

    protected AbstractCuboid(@NotNull Cube cube) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        this.cube = cube;
        this.isDirty = true;
    }

    @Override
    @NotNull
    public Cube getCube() {
        return this.cube;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    protected void build() {
        this.setDirty(false);
        this.distributiveStatisticsCache = CollectionFactory.INSTANCE.concurrentHashMap();
        this.univariateStatisticsCache = CollectionFactory.INSTANCE.concurrentHashMap();
        this.aggregateCache = CollectionFactory.INSTANCE.concurrentHashMap();
        this.distinctCache = CollectionFactory.INSTANCE.concurrentHashMap();
    }

    @Override
    @Nullable
    public DistributiveStatistics getDistributiveStatistics(@Nullable Group group, @NotNull Series<Object, Object> column, @Nullable DistributiveStatistics.RowFilter<Object> rowExcluder) {
        DistributiveStatistics distributiveStatistics;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (this.isDirty()) {
            this.build();
        }
        if (group != null) {
            GroupColumn key = new GroupColumn(group, column, rowExcluder);
            Map<GroupColumn, DistributiveStatistics> map = this.distributiveStatisticsCache;
            Intrinsics.checkNotNull(map);
            if (!map.containsKey(key)) {
                Cuboid child = this.getCube().getChildCuboid(this);
                DistributiveStatistics distributiveStatistics2 = null;
                if (child != null) {
                    distributiveStatistics2 = new DistributiveStatistics();
                    Iterable<Group> iterable = child.getGroupsStartingWith(group);
                    Intrinsics.checkNotNull(iterable);
                    for (Group childGroup : iterable) {
                        DistributiveStatistics childDistributiveStatistics;
                        DistributiveStatistics distributiveStatistics3 = childDistributiveStatistics = child.getDistributiveStatistics(childGroup, column, rowExcluder);
                        Intrinsics.checkNotNull((Object)distributiveStatistics3);
                        distributiveStatistics2.add(distributiveStatistics3);
                    }
                } else {
                    Iterable<Object> rows = this.getRows(group);
                    distributiveStatistics2 = rows != null ? new DistributiveStatistics(column, rows, rowExcluder) : null;
                }
                Map<GroupColumn, DistributiveStatistics> map2 = this.distributiveStatisticsCache;
                Intrinsics.checkNotNull(map2);
                map2.put(key, distributiveStatistics2);
                return distributiveStatistics2;
            }
            Map<GroupColumn, DistributiveStatistics> map3 = this.distributiveStatisticsCache;
            Intrinsics.checkNotNull(map3);
            distributiveStatistics = map3.get(key);
        } else {
            distributiveStatistics = null;
        }
        return distributiveStatistics;
    }

    @Override
    @Nullable
    public UnivariateStatistics getUnivariateStatistics(@Nullable Group group, @Nullable Series<Object, Object> column) {
        UnivariateStatistics univariateStatistics;
        if (this.isDirty()) {
            this.build();
        }
        if (group != null) {
            GroupColumn key = new GroupColumn(group, column, null);
            Map<GroupColumn, UnivariateStatistics> map = this.univariateStatisticsCache;
            Intrinsics.checkNotNull(map);
            if (!map.containsKey(key)) {
                UnivariateStatistics univariateStatistics2 = null;
                Iterable<Object> rows = this.getRows(group);
                if (rows != null) {
                    Series<Object, Object> series = column;
                    Intrinsics.checkNotNull(series);
                    univariateStatistics2 = new UnivariateStatistics(rows, series);
                } else {
                    univariateStatistics2 = null;
                }
                Map<GroupColumn, UnivariateStatistics> map2 = this.univariateStatisticsCache;
                Intrinsics.checkNotNull(map2);
                map2.put(key, univariateStatistics2);
                return univariateStatistics2;
            }
            Map<GroupColumn, UnivariateStatistics> map3 = this.univariateStatisticsCache;
            Intrinsics.checkNotNull(map3);
            univariateStatistics = map3.get(key);
        } else {
            univariateStatistics = null;
        }
        return univariateStatistics;
    }

    @Override
    @Nullable
    public <T> T getAggregate(@Nullable Group group, @Nullable AggregateSeriesFunction<T> func2) {
        Object object;
        if (this.isDirty()) {
            this.build();
        }
        if (group != null) {
            GroupAggregation key = new GroupAggregation(group, func2);
            Map<GroupAggregation, Object> map = this.aggregateCache;
            Intrinsics.checkNotNull(map);
            if (!map.containsKey(key)) {
                T t;
                T aggregate2 = null;
                Iterable<Object> rows = this.getRows(group);
                if (rows != null) {
                    AggregateSeriesFunction<T> aggregateSeriesFunction = func2;
                    Intrinsics.checkNotNull(aggregateSeriesFunction);
                    t = aggregateSeriesFunction.aggregate(this, rows);
                } else {
                    t = null;
                }
                aggregate2 = t;
                Map<GroupAggregation, Object> map2 = this.aggregateCache;
                Intrinsics.checkNotNull(map2);
                map2.put(key, aggregate2);
                return aggregate2;
            }
            Map<GroupAggregation, Object> map3 = this.aggregateCache;
            Intrinsics.checkNotNull(map3);
            object = map3.get(key);
        } else {
            object = null;
        }
        return (T)object;
    }

    @Override
    @Nullable
    public Set<Object> getDistinct(@Nullable Group group, @NotNull Series<Object, Object> column) {
        Set<Object> set;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (this.isDirty()) {
            this.build();
        }
        if (group != null) {
            GroupColumn key = new GroupColumn(group, column, null);
            Map<GroupColumn, Set<Object>> map = this.distinctCache;
            Intrinsics.checkNotNull(map);
            if (!map.containsKey(key)) {
                Cuboid child = this.getCube().getChildCuboid(this);
                Set set2 = null;
                if (child != null) {
                    set2 = new HashSet();
                    Iterable<Group> iterable = child.getGroupsStartingWith(group);
                    Intrinsics.checkNotNull(iterable);
                    for (Group childGroup : iterable) {
                        Set<Object> childSet = child.getDistinct(childGroup, column);
                        HashSet hashSet = (HashSet)set2;
                        Set<Object> set3 = childSet;
                        Intrinsics.checkNotNull(set3);
                        hashSet.addAll((Collection)set3);
                    }
                } else {
                    Iterable<Object> rows = this.getRows(group);
                    if (rows != null) {
                        set2 = new HashSet();
                        for (Object row : rows) {
                            Object value = column.get(row);
                            HashSet hashSet = (HashSet)set2;
                            Object object = value;
                            Intrinsics.checkNotNull((Object)object);
                            hashSet.add(object);
                        }
                    } else {
                        set2 = null;
                    }
                }
                Map<GroupColumn, Set<Object>> map2 = this.distinctCache;
                Intrinsics.checkNotNull(map2);
                map2.put(key, set2);
                return set2;
            }
            Map<GroupColumn, Set<Object>> map3 = this.distinctCache;
            Intrinsics.checkNotNull(map3);
            set = map3.get(key);
        } else {
            set = null;
        }
        return set;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/molap/aggregates/cuboid/AbstractCuboid$GroupAggregation;", "", "group", "Lorg/molap/aggregates/cube/Group;", "aggregateSeriesFunction", "Lorg/molap/aggregates/aggregation/AggregateSeriesFunction;", "<init>", "(Lorg/molap/aggregates/cube/Group;Lorg/molap/aggregates/aggregation/AggregateSeriesFunction;)V", "equals", "", "o", "hashCode", "", "toString", "", "molap"})
    private static final class GroupAggregation {
        @Nullable
        private final Group group;
        @Nullable
        private final AggregateSeriesFunction<?> aggregateSeriesFunction;

        public GroupAggregation(@Nullable Group group, @Nullable AggregateSeriesFunction<?> aggregateSeriesFunction) {
            this.group = group;
            this.aggregateSeriesFunction = aggregateSeriesFunction;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupAggregation that = (GroupAggregation)o;
            return !Intrinsics.areEqual((Object)this.group, (Object)that.group) ? false : !(this.aggregateSeriesFunction != null ? !this.aggregateSeriesFunction.equals(that.aggregateSeriesFunction) : that.aggregateSeriesFunction != null);
        }

        public int hashCode() {
            Group group = this.group;
            int result = group != null ? group.hashCode() : 0;
            result = 31 * result + (this.aggregateSeriesFunction != null ? this.aggregateSeriesFunction.hashCode() : 0);
            return result;
        }

        @NotNull
        public String toString() {
            Group group = this.group;
            AggregateSeriesFunction<?> aggregateSeriesFunction = this.aggregateSeriesFunction;
            return "GroupColumn{group=" + this.group + "group=" + (group != null ? group.hashCode() : 0) + ", aggregateSeriesFunction=" + this.aggregateSeriesFunction + ", aggregateSeriesFunction=" + (aggregateSeriesFunction != null ? aggregateSeriesFunction.hashCode() : 0) + "}";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/molap/aggregates/cuboid/AbstractCuboid$GroupColumn;", "", "group", "Lorg/molap/aggregates/cube/Group;", "column", "Lorg/molap/series/Series;", "rowFilter", "Lorg/molap/aggregates/cube/DistributiveStatistics$RowFilter;", "<init>", "(Lorg/molap/aggregates/cube/Group;Lorg/molap/series/Series;Lorg/molap/aggregates/cube/DistributiveStatistics$RowFilter;)V", "equals", "", "o", "hashCode", "", "toString", "", "molap"})
    private static final class GroupColumn {
        @Nullable
        private final Group group;
        @Nullable
        private final Series<?, ?> column;
        @Nullable
        private final DistributiveStatistics.RowFilter<?> rowFilter;

        public GroupColumn(@Nullable Group group, @Nullable Series<?, ?> column, @Nullable DistributiveStatistics.RowFilter<?> rowFilter) {
            this.group = group;
            this.column = column;
            this.rowFilter = rowFilter;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupColumn that = (GroupColumn)o;
            if (!Intrinsics.areEqual((Object)this.group, (Object)that.group)) {
                return false;
            }
            return !Intrinsics.areEqual(this.column, that.column) ? false : !(this.rowFilter != null ? !this.rowFilter.equals(that.rowFilter) : that.rowFilter != null);
        }

        public int hashCode() {
            Group group = this.group;
            int result = group != null ? group.hashCode() : 0;
            Series<?, ?> series = this.column;
            result = 31 * result + (series != null ? series.hashCode() : 0);
            result = 31 * result + (this.rowFilter != null ? this.rowFilter.hashCode() : 0);
            return result;
        }

        @NotNull
        public String toString() {
            Group group = this.group;
            Series<?, ?> series = this.column;
            return "GroupColumn{group=" + this.group + "group=" + (group != null ? group.hashCode() : 0) + ", column=" + this.column + ", column=" + (series != null ? series.hashCode() : 0) + "}";
        }
    }
}

