/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.query;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.AggregateDataFrame;
import org.molap.aggregates.aggregation.Aggregation;
import org.molap.aggregates.cube.Cube;
import org.molap.aggregates.cube.Dimensions;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.aggregates.query.Query;
import org.molap.aggregates.query.QueryListener;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.ReIndexRecipe;
import org.molap.dataframe.ReIndexedDataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.MultiKey;
import org.molap.index.UniqueIndex;
import org.molap.series.AbstractSeries;
import org.molap.series.Series;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0006:\u0002OPB\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001f\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0016J \u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0010\u0010%\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J;\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062&\u0010)\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010*0\u001f\"\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010+J \u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0010\u0010-\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010*H\u0016J'\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001f\"\u00020\u001aH\u0016\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u0001022\b\u00103\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0005022\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0016J\u001e\u00106\u001a\u0004\u0018\u00010\u00052\b\u00107\u001a\u0004\u0018\u00010\u00032\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0016J\u001c\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u0001092\b\u00103\u001a\u0004\u0018\u00010\u0003J\"\u0010:\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0005092\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00030<H\u0016J\u0010\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040<H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\u00032\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00042\u0006\u0010>\u001a\u00020?H\u0016J\u0012\u0010A\u001a\u00020?2\b\u00103\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010B\u001a\u00020?2\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0016J7\u0010H\u001a\u0016\u0012\u0004\u0012\u00020J\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050I2\u0016\u0010;\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u001f\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010KJ=\u0010L\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010I2\u0010\u0010M\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u0001092\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010NR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R \u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u000e8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R \u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u000e8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010C\u001a\u00020?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0014\u0010F\u001a\u00020?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010E\u00a8\u0006Q"}, d2={"Lorg/molap/aggregates/query/QueryDataFrame;", "C", "Lorg/molap/dataframe/AbstractDataFrame;", "Lorg/molap/aggregates/cube/Group;", "", "", "Lorg/molap/aggregates/AggregateDataFrame;", "query", "Lorg/molap/aggregates/query/Query;", "includeIndex", "", "<init>", "(Lorg/molap/aggregates/query/Query;Z)V", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "columnIndex", "getColumnIndex", "cacheRowIndex", "getCacheRowIndex", "cacheColumnIndex", "getCacheColumnIndex", "queryListener", "Lorg/molap/aggregates/query/QueryListener;", "cuboid", "Lorg/molap/aggregates/cuboid/Cuboid;", "getCuboid", "()Lorg/molap/aggregates/cuboid/Cuboid;", "drillDown", "columns", "", "([Ljava/lang/Object;)Lorg/molap/aggregates/AggregateDataFrame;", "drillUp", "slice", "value", "dice", "valuesSets", "", "collapse", "order", "aggregations", "Lorg/molap/aggregates/aggregation/Aggregation;", "([Lorg/molap/aggregates/aggregation/Aggregation;)Lorg/molap/aggregates/AggregateDataFrame;", "pivot", "aggregation", "on", "cuboids", "([Lorg/molap/aggregates/cuboid/Cuboid;)Lorg/molap/aggregates/AggregateDataFrame;", "getRowClass", "Lkotlin/reflect/KClass;", "row", "getColumnClass", "column", "getValueAt", "path", "getRow", "Lorg/molap/series/Series;", "getColumn", "rows", "", "getRowKey", "index", "", "getColumnKey", "getRowAddress", "getColumnAddress", "rowCount", "getRowCount", "()I", "columnCount", "getColumnCount", "reindexRowsUsingColumns", "Lorg/molap/dataframe/DataFrame;", "Lorg/molap/index/MultiKey;", "([Ljava/lang/String;)Lorg/molap/dataframe/DataFrame;", "join", "series", "(Lorg/molap/series/Series;[Ljava/lang/String;)Lorg/molap/dataframe/DataFrame;", "DimensionSeries", "AggregationSeries", "molap"})
public final class QueryDataFrame<C>
extends AbstractDataFrame<Group, String, Object>
implements AggregateDataFrame<C> {
    @NotNull
    private final Query query;
    private final boolean includeIndex;
    @Nullable
    private UniqueIndex<Group> cacheRowIndex;
    @Nullable
    private UniqueIndex<String> cacheColumnIndex;
    @NotNull
    private final QueryListener queryListener;

    public QueryDataFrame(@NotNull Query query, boolean includeIndex) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.queryListener = new QueryListener(this){
            final /* synthetic */ QueryDataFrame<C> this$0;
            {
                this.this$0 = $receiver;
            }

            public void queryChanged() {
                QueryDataFrame.access$setCacheRowIndex$p(this.this$0, null);
                QueryDataFrame.access$setCacheColumnIndex$p(this.this$0, null);
                QueryDataFrame.access$notifyDataFrameChanged(this.this$0, new DataFrameEvent<R, C>(CollectionsKt.emptyList(), null, true));
            }
        };
        this.query = query;
        this.includeIndex = includeIndex;
        query.addWeakQueryListener(this.queryListener);
    }

    @Override
    @NotNull
    public UniqueIndex<Group> getRowIndex() {
        UniqueIndex<Group> uniqueIndex = this.getCacheRowIndex();
        Intrinsics.checkNotNull(uniqueIndex);
        return uniqueIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        UniqueIndex<String> uniqueIndex = this.getCacheColumnIndex();
        Intrinsics.checkNotNull(uniqueIndex);
        return uniqueIndex;
    }

    private final UniqueIndex<Group> getCacheRowIndex() {
        if (this.cacheRowIndex == null) {
            List<Object> list = this.query.getGroups();
            Intrinsics.checkNotNull(list);
            Group[] groups = new Group[list.size()];
            int i = 0;
            List<Object> list2 = this.query.getGroups();
            Intrinsics.checkNotNull(list2);
            for (Object g : list2) {
                int n = i++;
                Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type org.molap.aggregates.cube.Group");
                groups[n] = g;
            }
            this.cacheRowIndex = new DefaultUniqueIndex<Group>(Arrays.copyOf(groups, groups.length));
        }
        return this.cacheRowIndex;
    }

    private final UniqueIndex<String> getCacheColumnIndex() {
        if (this.cacheColumnIndex == null) {
            String[] names = new String[this.getColumnCount()];
            int n = this.getColumnCount();
            for (int c = 0; c < n; ++c) {
                names[c] = this.getColumnKey(c);
            }
            this.cacheColumnIndex = new DefaultUniqueIndex<String>(Arrays.copyOf(names, names.length));
        }
        return this.cacheColumnIndex;
    }

    @Override
    @Nullable
    public Cuboid getCuboid() {
        return this.query.getCuboid();
    }

    @Override
    @NotNull
    public AggregateDataFrame<C> drillDown(C ... columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        return new QueryDataFrame<C>(this.query.drillDown(Arrays.copyOf(columns, columns.length)), this.includeIndex);
    }

    @Override
    @NotNull
    public AggregateDataFrame<C> drillUp() {
        return new QueryDataFrame<C>(this.query.drillUp(), this.includeIndex);
    }

    @Override
    @NotNull
    public AggregateDataFrame<C> slice(@Nullable Object value) {
        return new QueryDataFrame<C>(this.query.slice(value), this.includeIndex);
    }

    @Override
    @NotNull
    public AggregateDataFrame<C> dice(@Nullable Set<? extends Object> valuesSets) {
        return new QueryDataFrame<C>(this.query.dice(valuesSets), this.includeIndex);
    }

    @Override
    @NotNull
    public AggregateDataFrame<C> collapse() {
        return new QueryDataFrame<C>(this.query.collapse(), this.includeIndex);
    }

    @Override
    @NotNull
    public AggregateDataFrame<C> order(Aggregation<Object> ... aggregations) {
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        return new QueryDataFrame<C>(this.query.order(Arrays.copyOf(aggregations, aggregations.length)), this.includeIndex);
    }

    @Override
    @NotNull
    public AggregateDataFrame<C> pivot(@Nullable Aggregation<Object> aggregation) {
        return new QueryDataFrame<C>(this.query.pivot(aggregation), this.includeIndex);
    }

    @Override
    @NotNull
    public AggregateDataFrame<C> on(Cuboid ... cuboids) {
        Intrinsics.checkNotNullParameter((Object)cuboids, (String)"cuboids");
        return new QueryDataFrame<C>(this.query.on(Arrays.copyOf(cuboids, cuboids.length)), this.includeIndex);
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(@Nullable Group row) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    @NotNull
    public KClass<? extends Object> getColumnClass(@Nullable String column) {
        KClass<Object> kClass;
        UniqueIndex<String> uniqueIndex = this.getColumnIndex();
        String string = column;
        Intrinsics.checkNotNull((Object)string);
        int columnIndex = uniqueIndex.getAddress(string);
        if (columnIndex >= 0) {
            if (this.includeIndex) {
                Dimensions dimensions = this.query.getDimensions();
                Intrinsics.checkNotNull((Object)dimensions);
                if (columnIndex < dimensions.getPath().length) {
                    Dimensions dimensions2 = this.query.getDimensions();
                    Intrinsics.checkNotNull((Object)dimensions2);
                    Object c = dimensions2.getPath()[columnIndex];
                    Cuboid cuboid = this.query.getCuboid();
                    Intrinsics.checkNotNull((Object)cuboid);
                    Cube cube = cuboid.getCube();
                    Intrinsics.checkNotNull((Object)cube);
                    DataFrame<Object, Object, Object> dataFrame = cube.getDataFrame();
                    return dataFrame.getColumnClass(c);
                }
                Dimensions dimensions3 = this.query.getDimensions();
                Intrinsics.checkNotNull((Object)dimensions3);
                columnIndex -= dimensions3.getPath().length;
            }
            kClass = this.query.getAggregations()[columnIndex].getType();
        } else {
            kClass = Reflection.getOrCreateKotlinClass(Object.class);
        }
        return kClass;
    }

    @Override
    @Nullable
    public Object getValueAt(@Nullable Group path, @Nullable String column) {
        Object object;
        UniqueIndex<String> uniqueIndex = this.getColumnIndex();
        String string = column;
        Intrinsics.checkNotNull((Object)string);
        Integer columnIndex = uniqueIndex.getAddress(string);
        if (columnIndex >= 0) {
            if (path == null) {
                System.out.println((Object)"QueryDataFrame: path is null");
            }
            if (this.includeIndex) {
                int n = columnIndex;
                Dimensions dimensions = this.query.getDimensions();
                Intrinsics.checkNotNull((Object)dimensions);
                if (n < dimensions.getPath().length) {
                    Object object2;
                    if (this.query.getDimensions() != null) {
                        Dimensions dimensions2 = this.query.getDimensions();
                        Intrinsics.checkNotNull((Object)dimensions2);
                        Object c = dimensions2.getPath()[columnIndex];
                        Dimensions dimensions3 = this.query.getDimensions();
                        Intrinsics.checkNotNull((Object)dimensions3);
                        columnIndex = dimensions3.getIndex(c);
                    }
                    if (path != null) {
                        Integer n2 = columnIndex;
                        Intrinsics.checkNotNull((Object)n2);
                        object2 = path.getPath(n2);
                    } else {
                        object2 = null;
                    }
                    return object2;
                }
                int n3 = columnIndex;
                Dimensions dimensions4 = this.query.getDimensions();
                Intrinsics.checkNotNull((Object)dimensions4);
                columnIndex = n3 - dimensions4.getPath().length;
            }
            object = this.query.getValue(path, this.query.getAggregations()[columnIndex]);
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final Series<String, ?> getRow(@Nullable Group row) {
        return null;
    }

    @Override
    @NotNull
    public Series<Group, Object> getColumn(@Nullable String column) {
        UniqueIndex<String> uniqueIndex = this.getColumnIndex();
        String string = column;
        Intrinsics.checkNotNull((Object)string);
        int columnIndex = uniqueIndex.getAddress(string);
        if (this.includeIndex) {
            Dimensions dimensions = this.query.getDimensions();
            Intrinsics.checkNotNull((Object)dimensions);
            if (columnIndex < dimensions.getPath().length) {
                Cuboid cuboid = this.query.getCuboid();
                Intrinsics.checkNotNull((Object)cuboid);
                Cube cube = cuboid.getCube();
                Intrinsics.checkNotNull((Object)cube);
                DataFrame<Object, Object, Object> dataFrame = cube.getDataFrame();
                Intrinsics.checkNotNull(dataFrame, (String)"null cannot be cast to non-null type org.molap.dataframe.DataFrame<org.molap.aggregates.cube.Group, kotlin.String, kotlin.Any>");
                return new DimensionSeries(dataFrame, column, columnIndex);
            }
            Dimensions dimensions2 = this.query.getDimensions();
            Intrinsics.checkNotNull((Object)dimensions2);
            columnIndex -= dimensions2.getPath().length;
        }
        return new AggregationSeries(this.query.getAggregations()[columnIndex], column);
    }

    @Override
    @NotNull
    public Iterable<Group> rows() {
        List<Object> list = this.query.getGroups();
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<org.molap.aggregates.cube.Group>");
        return list;
    }

    @Override
    @NotNull
    public Iterable<String> columns() {
        return this.getColumnIndex().keys();
    }

    @Override
    @Nullable
    public Group getRowKey(int index) {
        Query query = this.query;
        Intrinsics.checkNotNull((Object)query);
        List<Object> list = query.getGroups();
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<org.molap.aggregates.cube.Group>");
        List<Object> groups = list;
        return index >= 0 && index < groups.size() ? (Group)groups.get(index) : null;
    }

    @Override
    @NotNull
    public String getColumnKey(int index) {
        int index2 = index;
        if (this.includeIndex) {
            Dimensions dimensions = this.query.getDimensions();
            Intrinsics.checkNotNull((Object)dimensions);
            if (index2 < dimensions.getPath().length) {
                Dimensions dimensions2 = this.query.getDimensions();
                Intrinsics.checkNotNull((Object)dimensions2);
                return String.valueOf(dimensions2.getPath()[index2]);
            }
            Dimensions dimensions3 = this.query.getDimensions();
            Intrinsics.checkNotNull((Object)dimensions3);
            index2 -= dimensions3.getPath().length;
        }
        String string = this.query.getAggregations()[index2].getName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    public int getRowAddress(@Nullable Group row) {
        UniqueIndex<Group> uniqueIndex = this.getRowIndex();
        Group group = row;
        Intrinsics.checkNotNull((Object)group);
        return uniqueIndex.getAddress(group);
    }

    @Override
    public int getColumnAddress(@Nullable String column) {
        UniqueIndex<String> uniqueIndex = this.getColumnIndex();
        String string = column;
        Intrinsics.checkNotNull((Object)string);
        return uniqueIndex.getAddress(string);
    }

    @Override
    public int getRowCount() {
        List<Object> list = this.query.getGroups();
        Intrinsics.checkNotNull(list);
        return list.size();
    }

    @Override
    public int getColumnCount() {
        int n;
        if (this.includeIndex) {
            Dimensions dimensions = this.query.getDimensions();
            Intrinsics.checkNotNull((Object)dimensions);
            n = dimensions.getPath().length + this.query.getAggregations().length;
        } else {
            n = this.query.getAggregations().length;
        }
        return n;
    }

    @NotNull
    public final DataFrame<MultiKey, String, Object> reindexRowsUsingColumns(String ... rows) {
        Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.molap.dataframe.DataFrame<org.molap.aggregates.cube.Group, kotlin.String, kotlin.Any>");
        return new ReIndexedDataFrame(this, new ReIndexRecipe<MultiKey, String>(this, rows){
            final /* synthetic */ QueryDataFrame<C> this$0;
            final /* synthetic */ String[] $rows;
            {
                this.this$0 = $receiver;
                this.$rows = $rows;
            }

            public UniqueIndex<MultiKey> buildRowIndex() {
                int r = 0;
                Object[] keys2 = new MultiKey[((DataFrame)this.this$0).getRowCount()];
                for (Group row : ((DataFrame)this.this$0).rows()) {
                    Object[] values = new Object[this.$rows.length];
                    int c = 0;
                    for (String column : this.$rows) {
                        values[c++] = this.this$0.getValueAt(row, column);
                    }
                    Object[] objectArray = new Object[]{values};
                    MultiKey key = new MultiKey(objectArray);
                    keys2[r++] = key;
                }
                MultiKey[] multiKeyArray = (MultiKey[])ArraysKt.requireNoNulls((Object[])keys2);
                return new DefaultUniqueIndex<MultiKey>(Arrays.copyOf(multiKeyArray, multiKeyArray.length));
            }

            public UniqueIndex<String> buildColumnIndex() {
                return ((DataFrame)this.this$0).getColumnIndex();
            }
        });
    }

    @Nullable
    public final DataFrame<?, ?, ?> join(@Nullable Series<?, ?> series, @Nullable String[] columns) {
        return null;
    }

    public static final /* synthetic */ void access$setCacheRowIndex$p(QueryDataFrame $this, UniqueIndex uniqueIndex) {
        $this.cacheRowIndex = uniqueIndex;
    }

    public static final /* synthetic */ void access$setCacheColumnIndex$p(QueryDataFrame $this, UniqueIndex uniqueIndex) {
        $this.cacheColumnIndex = uniqueIndex;
    }

    public static final /* synthetic */ void access$notifyDataFrameChanged(QueryDataFrame $this, DataFrameEvent event) {
        $this.notifyDataFrameChanged(event);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u001f\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0012\u0010\u0017\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J3\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001b\"\u0004\b\u0001\u0010\u001c2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001c0\u001d\"\u0002H\u001c\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020\u0015J\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020\u0015R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/molap/aggregates/query/QueryDataFrame$AggregationSeries;", "Lorg/molap/series/AbstractSeries;", "Lorg/molap/aggregates/cube/Group;", "", "aggregation", "Lorg/molap/aggregates/aggregation/Aggregation;", "column", "", "<init>", "(Lorg/molap/aggregates/query/QueryDataFrame;Lorg/molap/aggregates/aggregation/Aggregation;Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "get", "key", "getKey", "i", "", "size", "getAddress", "keys", "", "reindex", "Lorg/molap/series/Series;", "L", "", "([Ljava/lang/Object;)Lorg/molap/series/Series;", "head", "count", "tail", "molap"})
    private final class AggregationSeries
    extends AbstractSeries<Group, Object> {
        @NotNull
        private final Aggregation<Object> aggregation;
        @NotNull
        private final String column;

        public AggregationSeries(@NotNull Aggregation<Object> aggregation, String column) {
            Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            this.aggregation = aggregation;
            this.column = column;
        }

        @Override
        @NotNull
        public Object getName() {
            return this.column;
        }

        @Override
        @NotNull
        public KClass<Object> getType() {
            return Reflection.getOrCreateKotlinClass(Double.TYPE);
        }

        @Override
        @Nullable
        public Object get(@Nullable Group key) {
            return QueryDataFrame.this.query.getValue(key, this.aggregation);
        }

        @Override
        @Nullable
        public Group getKey(int i) {
            return QueryDataFrame.this.getRowKey(i);
        }

        @Override
        public int size() {
            return QueryDataFrame.this.getRowCount();
        }

        @Override
        public int getAddress(@Nullable Group key) {
            return QueryDataFrame.this.getRowAddress(key);
        }

        @Override
        @NotNull
        public Iterable<Group> keys() {
            return QueryDataFrame.this.rows();
        }

        @Nullable
        public final <L> Series<L, Object> reindex(L ... keys2) {
            Intrinsics.checkNotNullParameter(keys2, (String)"keys");
            return null;
        }

        @Nullable
        public final Series<Group, Object> head(int count) {
            return null;
        }

        @Nullable
        public final Series<Group, Object> tail(int count) {
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B1\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\u0012\u0010\u0018\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016J3\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001c\"\u0004\b\u0001\u0010\u001d2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001d0\u001e\"\u0002H\u001d\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001c2\u0006\u0010!\u001a\u00020\tJ\u001c\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001c2\u0006\u0010!\u001a\u00020\tR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/molap/aggregates/query/QueryDataFrame$DimensionSeries;", "Lorg/molap/series/AbstractSeries;", "Lorg/molap/aggregates/cube/Group;", "", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "", "column", "columnIndex", "", "<init>", "(Lorg/molap/aggregates/query/QueryDataFrame;Lorg/molap/dataframe/DataFrame;Ljava/lang/String;I)V", "name", "getName", "()Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "get", "key", "getKey", "i", "size", "getAddress", "keys", "", "reindex", "Lorg/molap/series/Series;", "L", "", "([Ljava/lang/Object;)Lorg/molap/series/Series;", "head", "count", "tail", "molap"})
    private final class DimensionSeries
    extends AbstractSeries<Group, Object> {
        @NotNull
        private final DataFrame<Group, String, Object> dataFrame;
        @NotNull
        private final String column;
        private final int columnIndex;

        public DimensionSeries(@NotNull DataFrame<Group, String, Object> dataFrame, String column, int columnIndex) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            this.dataFrame = dataFrame;
            this.column = column;
            this.columnIndex = columnIndex;
        }

        @Override
        @NotNull
        public Object getName() {
            return this.column;
        }

        @Override
        @NotNull
        public KClass<? extends Object> getType() {
            return this.dataFrame.getColumnClass(this.column);
        }

        @Override
        @Nullable
        public Object get(@Nullable Group key) {
            return key != null ? key.getPath(this.columnIndex) : null;
        }

        @Override
        @Nullable
        public Group getKey(int i) {
            return QueryDataFrame.this.getRowKey(i);
        }

        @Override
        public int size() {
            return QueryDataFrame.this.getRowCount();
        }

        @Override
        public int getAddress(@Nullable Group key) {
            return QueryDataFrame.this.getRowAddress(key);
        }

        @Override
        @NotNull
        public Iterable<Group> keys() {
            return QueryDataFrame.this.rows();
        }

        @Nullable
        public final <L> Series<L, Object> reindex(L ... keys2) {
            Intrinsics.checkNotNullParameter(keys2, (String)"keys");
            return null;
        }

        @Nullable
        public final Series<Group, Object> head(int count) {
            return null;
        }

        @Nullable
        public final Series<Group, Object> tail(int count) {
            return null;
        }
    }
}

