/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001d2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u001d\u0010\"\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010#R\u001b\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR!\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000b0\u000b\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001a\u0010\u0016\u00a8\u0006$"}, d2={"Lorg/molap/dataframe/RandomDataFrame;", "Lorg/molap/dataframe/AbstractDataFrame;", "", "", "", "clusterCount", "rowCount", "columnCount", "<init>", "(III)V", "columnNames", "", "getColumnNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "data", "getData", "()[[Ljava/lang/Double;", "[[Ljava/lang/Double;", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "rowIndex$delegate", "Lkotlin/Lazy;", "columnIndex", "getColumnIndex", "columnIndex$delegate", "getRowClass", "Lkotlin/reflect/KClass;", "row", "getColumnClass", "", "column", "getValueAt", "(ILjava/lang/String;)Ljava/lang/Double;", "molap"})
public final class RandomDataFrame
extends AbstractDataFrame<Integer, String, Double> {
    @NotNull
    private final String[] columnNames;
    @NotNull
    private final Double[][] data;
    @NotNull
    private final Lazy rowIndex$delegate;
    @NotNull
    private final Lazy columnIndex$delegate;

    public RandomDataFrame(int clusterCount, int rowCount, int columnCount) {
        int r;
        int n;
        Random random = RandomKt.Random((int)0);
        this.columnNames = new String[columnCount];
        for (int c = 0; c < columnCount; ++c) {
            this.columnNames[c] = String.valueOf(c);
        }
        int n2 = 0;
        double[][] dArrayArray = new double[clusterCount][];
        while (n2 < clusterCount) {
            n = n2++;
            dArrayArray[n] = new double[columnCount];
        }
        double[][] clusters = dArrayArray;
        for (r = 0; r < clusterCount; ++r) {
            for (int c = 0; c < columnCount; ++c) {
                clusters[r][c] = random.nextDouble();
            }
        }
        r = 0;
        Double[][] c = new Double[rowCount][];
        RandomDataFrame randomDataFrame = this;
        while (r < rowCount) {
            n = r++;
            c[n] = new Double[columnCount];
        }
        randomDataFrame.data = c;
        for (r = 0; r < rowCount; ++r) {
            int cluster = (int)Math.abs((double)(random.nextInt() % clusterCount));
            for (int c2 = 0; c2 < columnCount; ++c2) {
                double centroid = clusters[cluster][c2];
                this.data[r][c2] = centroid + random.nextDouble() / (double)30;
            }
        }
        this.rowIndex$delegate = LazyKt.lazy(() -> RandomDataFrame.rowIndex_delegate$lambda$0(rowCount));
        this.columnIndex$delegate = LazyKt.lazy(() -> RandomDataFrame.columnIndex_delegate$lambda$1(this));
    }

    @NotNull
    public final String[] getColumnNames() {
        return this.columnNames;
    }

    @NotNull
    public final Double[][] getData() {
        return this.data;
    }

    @Override
    @NotNull
    public UniqueIndex<Integer> getRowIndex() {
        Lazy lazy = this.rowIndex$delegate;
        return (UniqueIndex)lazy.getValue();
    }

    @Override
    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        Lazy lazy = this.columnIndex$delegate;
        return (UniqueIndex)lazy.getValue();
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(int row) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    @NotNull
    public KClass<? extends Object> getColumnClass(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return Reflection.getOrCreateKotlinClass(Double.TYPE);
    }

    @Override
    @NotNull
    public Double getValueAt(int row, @NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Double d = this.data[this.getRowIndex().getAddress(row)][this.getColumnIndex().getAddress(column)];
        Intrinsics.checkNotNull((Object)d);
        return d;
    }

    private static final IntegerRangeUniqueIndex rowIndex_delegate$lambda$0(int $rowCount) {
        return new IntegerRangeUniqueIndex(0, $rowCount - 1);
    }

    private static final DefaultUniqueIndex columnIndex_delegate$lambda$1(RandomDataFrame this$0) {
        Object[] names = new String[this$0.columnNames.length];
        for (Object names[c] : this$0.columnNames) {
        }
        String[] stringArray = (String[])ArraysKt.requireNoNulls((Object[])names);
        return new DefaultUniqueIndex<String>(Arrays.copyOf(stringArray, stringArray.length));
    }
}

