/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B/\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u00192\u0006\u0010\u001e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001f\u001a\u00028\u00022\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010\"H\u0016J\u0015\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020&H\u0016\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00028\u00012\u0006\u0010%\u001a\u00020&H\u0016\u00a2\u0006\u0002\u0010'J\u0015\u0010)\u001a\u00020&2\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u00020&2\u0006\u0010\u001e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010*R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0014\u0010,\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010.\u00a8\u00061"}, d2={"Lorg/molap/dataframe/SelectionDataFrame;", "R", "C", "V", "Lorg/molap/dataframe/AbstractDataFrame;", "dataFrame", "filter", "Lcom/macrofocus/common/selection/Selection;", "<init>", "(Lorg/molap/dataframe/AbstractDataFrame;Lcom/macrofocus/common/selection/Selection;)V", "dataFrameListener", "Lorg/molap/dataframe/DataFrameListener;", "selectionListener", "Lcom/macrofocus/common/selection/SelectionListener;", "cacheRowIndex", "Lorg/molap/index/UniqueIndex;", "getCacheRowIndex", "()Lorg/molap/index/UniqueIndex;", "setCacheRowIndex", "(Lorg/molap/index/UniqueIndex;)V", "rowIndex", "getRowIndex", "columnIndex", "getColumnIndex", "getRowClass", "Lkotlin/reflect/KClass;", "r", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "getColumnClass", "", "c", "getValueAt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "rows", "", "columns", "getRowKey", "index", "", "(I)Ljava/lang/Object;", "getColumnKey", "getRowAddress", "(Ljava/lang/Object;)I", "getColumnAddress", "rowCount", "getRowCount", "()I", "columnCount", "getColumnCount", "molap"})
public final class SelectionDataFrame<R, C, V>
extends AbstractDataFrame<R, C, V> {
    @NotNull
    private final AbstractDataFrame<R, C, V> dataFrame;
    @NotNull
    private final Selection<R> filter;
    @NotNull
    private final DataFrameListener<R, C> dataFrameListener;
    @NotNull
    private final SelectionListener<R> selectionListener;
    @Nullable
    private UniqueIndex<R> cacheRowIndex;

    public SelectionDataFrame(@NotNull AbstractDataFrame<R, C, V> dataFrame, @NotNull Selection<R> filter) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        this.dataFrame = dataFrame;
        this.filter = filter;
        this.dataFrameListener = new DataFrameListener<R, C>(this){
            final /* synthetic */ SelectionDataFrame<R, C, V> this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataFrameChanged(DataFrameEvent<R, C> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.setCacheRowIndex(null);
                this.this$0.notifyDataFrameChanged(new DataFrameEvent<R, C>(null, null, true));
            }
        };
        this.selectionListener = new SelectionListener<R>(this){
            final /* synthetic */ SelectionDataFrame<R, C, V> this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(SelectionEvent<R> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.setCacheRowIndex(null);
                this.this$0.notifyDataFrameChanged(new DataFrameEvent<R, C>(null, null, true));
            }
        };
        this.dataFrame.addWeakDataFrameListener(this.dataFrameListener);
        this.filter.addWeakSelectionListener(this.selectionListener);
    }

    @Nullable
    public final UniqueIndex<R> getCacheRowIndex() {
        return this.cacheRowIndex;
    }

    public final void setCacheRowIndex(@Nullable UniqueIndex<R> uniqueIndex) {
        this.cacheRowIndex = uniqueIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<R> getRowIndex() {
        UniqueIndex<R> uniqueIndex;
        if (this.cacheRowIndex == null) {
            List rows = new ArrayList();
            for (R row : this.dataFrame.rows()) {
                if (!this.filter.isSelected(row)) continue;
                rows.add(row);
            }
            this.cacheRowIndex = new DefaultUniqueIndex(rows);
            UniqueIndex<R> uniqueIndex2 = this.cacheRowIndex;
            uniqueIndex = uniqueIndex2;
            Intrinsics.checkNotNull(uniqueIndex2);
        } else {
            UniqueIndex<R> uniqueIndex3 = this.cacheRowIndex;
            uniqueIndex = uniqueIndex3;
            Intrinsics.checkNotNull(uniqueIndex3);
        }
        return uniqueIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<C> getColumnIndex() {
        return this.dataFrame.getColumnIndex();
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(R r) {
        return this.dataFrame.getRowClass(r);
    }

    @Override
    @NotNull
    public KClass<? extends Object> getColumnClass(C c) {
        return this.dataFrame.getColumnClass(c);
    }

    @Override
    public V getValueAt(R r, C c) {
        return this.dataFrame.getValueAt(r, c);
    }

    @Override
    @NotNull
    public Iterable<R> rows() {
        return this.getRowIndex().keys();
    }

    @Override
    @NotNull
    public Iterable<C> columns() {
        return this.dataFrame.columns();
    }

    @Override
    public R getRowKey(int index) {
        return (R)this.getRowIndex().getKey(index);
    }

    @Override
    public C getColumnKey(int index) {
        return this.dataFrame.getColumnKey(index);
    }

    @Override
    public int getRowAddress(R r) {
        return this.getRowIndex().getAddress(r);
    }

    @Override
    public int getColumnAddress(C c) {
        return this.dataFrame.getColumnAddress(c);
    }

    @Override
    public int getRowCount() {
        return this.getRowIndex().getSize();
    }

    @Override
    public int getColumnCount() {
        return this.dataFrame.getColumnCount();
    }
}

