/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe.rowmajor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractMutableDataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.rowmajor.RowMajorDataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005:\b01234567B\u001b\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0007\"\u00028\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cJ\u001d\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u001d\u0010&\u001a\u00020\u00182\u0006\u0010%\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0015\u0010'\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ(\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)2\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020+H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010,\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u00068"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "R", "C", "V", "Lorg/molap/dataframe/AbstractMutableDataFrame;", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame;", "columns", "", "<init>", "([Ljava/lang/Object;)V", "columnIndex", "Lorg/molap/index/UniqueIndex;", "getColumnIndex", "()Lorg/molap/index/UniqueIndex;", "rowIndex", "getRowIndex", "lazyRowIndex", "rows", "", "getRowClass", "Lkotlin/reflect/KClass;", "r", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "addRow", "", "row", "(Ljava/lang/Object;)V", "setRows", "", "replaceRow", "oldRow", "newRow", "(Ljava/lang/Object;Ljava/lang/Object;)V", "i", "", "(ILjava/lang/Object;)V", "addBeforeRow", "insertionPoint", "addAfterRow", "remove", "retrieve", "", "query", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "queryBuilder", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$QueryBuilder;", "getQueryBuilder", "()Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$QueryBuilder;", "DefaultQueryBuilder", "AbstractQuery", "And", "Or", "Equal", "SmallerThan", "GreaterThan", "Overlap", "molap"})
public abstract class AbstractRowMajorDataFrame<R, C, V>
extends AbstractMutableDataFrame<R, C, V>
implements RowMajorDataFrame<R, C, V> {
    @NotNull
    private final UniqueIndex<C> columnIndex;
    @Nullable
    private UniqueIndex<R> lazyRowIndex;
    @NotNull
    private final List<R> rows;
    @NotNull
    private final RowMajorDataFrame.QueryBuilder<R, C, V> queryBuilder;

    public AbstractRowMajorDataFrame(C ... columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columnIndex = new DefaultUniqueIndex<C>(Arrays.copyOf(columns, columns.length));
        this.rows = new ArrayList();
        this.queryBuilder = new DefaultQueryBuilder();
    }

    @Override
    @NotNull
    public UniqueIndex<C> getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<R> getRowIndex() {
        if (this.lazyRowIndex == null) {
            this.lazyRowIndex = new DefaultUniqueIndex((Iterable)this.rows, true);
        }
        UniqueIndex<R> uniqueIndex = this.lazyRowIndex;
        Intrinsics.checkNotNull(uniqueIndex);
        return uniqueIndex;
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(R r) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    public void addRow(R row) {
        this.rows.add(row);
        this.lazyRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    public final void setRows(@NotNull Iterable<? extends R> rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        List affected = CollectionsKt.plus((Collection)CollectionsKt.toList(this.rows()), rows);
        this.rows.clear();
        CollectionsKt.addAll((Collection)this.rows, rows);
        this.lazyRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(affected, null, false));
    }

    @Override
    public void replaceRow(R oldRow, R newRow) {
        this.rows.set(this.getRowIndex().getAddress(oldRow), newRow);
        this.lazyRowIndex = null;
        Object[] objectArray = new Object[]{oldRow, newRow};
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf((Object[])objectArray), null, false));
    }

    @Override
    public void addRow(int i, R row) {
        this.rows.add(i, row);
        this.lazyRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    @Override
    public void addBeforeRow(R insertionPoint, R row) {
        this.rows.add(this.getRowAddress(insertionPoint), row);
        this.lazyRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    @Override
    public void addAfterRow(R insertionPoint, R row) {
        this.rows.add(this.getRowAddress(insertionPoint) + 1, row);
        this.lazyRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    @Override
    public void remove(R row) {
        this.rows.remove(this.getRowAddress(row));
        this.lazyRowIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.listOf(row), null, false));
    }

    @Override
    @NotNull
    public List<R> retrieve(@NotNull RowMajorDataFrame.Query<R, C, V> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        List result = new ArrayList();
        for (Object row : this.rows()) {
            if (!query.matches(row)) continue;
            result.add(row);
        }
        return result;
    }

    @Override
    @NotNull
    public RowMajorDataFrame.QueryBuilder<R, C, V> getQueryBuilder() {
        return this.queryBuilder;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00a6\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0005\u001a\u00028\u00012\u0006\u0010\u0006\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007J/\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0005\u001a\u00028\u00012\u0006\u0010\u0006\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007J/\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0005\u001a\u00028\u00012\u0006\u0010\u0006\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007J/\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0005\u001a\u00028\u00012\u0006\u0010\u0006\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007J/\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0006\u0010\u0005\u001a\u00028\u00012\u0006\u0010\u0006\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007J4\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0001H\u0016J4\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0001H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "<init>", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;)V", "equal", "column", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "smallerThan", "smallerThanOrEqualTo", "greaterThan", "greaterThanOrEqualTo", "and", "query", "or", "molap"})
    public abstract class AbstractQuery
    implements RowMajorDataFrame.Query<R, C, V> {
        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> equal(C column, V value) {
            return new Equal(column, value);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> smallerThan(C column, V value) {
            return new SmallerThan(column, value, false);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> smallerThanOrEqualTo(C column, V value) {
            return new SmallerThan(column, value, true);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> greaterThan(C column, V value) {
            return new GreaterThan(column, value, false);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> greaterThanOrEqualTo(C column, V value) {
            return new GreaterThan(column, value, true);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> and(@NotNull RowMajorDataFrame.Query<R, C, V> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            RowMajorDataFrame.Query[] queryArray = new RowMajorDataFrame.Query[]{this, query};
            return new And(queryArray);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> or(@NotNull RowMajorDataFrame.Query<R, C, V> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            RowMajorDataFrame.Query[] queryArray = new RowMajorDataFrame.Query[]{this, query};
            return new Or(queryArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B?\u00126\u0010\u0003\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00050\u0004\"\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fR(\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\r"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$And;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "queries", "", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "<init>", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;[Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;)V", "[Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "matches", "", "row", "(Ljava/lang/Object;)Z", "molap"})
    @SourceDebugExtension(value={"SMAP\nAbstractRowMajorDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractRowMajorDataFrame.kt\norg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$And\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,272:1\n37#2:273\n36#2,3:274\n*S KotlinDebug\n*F\n+ 1 AbstractRowMajorDataFrame.kt\norg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$And\n*L\n162#1:273\n162#1:274,3\n*E\n"})
    public final class And
    extends AbstractQuery {
        @NotNull
        private final RowMajorDataFrame.Query<R, C, V>[] queries;

        public And(RowMajorDataFrame.Query<R, C, V> ... queries) {
            Intrinsics.checkNotNullParameter(queries, (String)"queries");
            Collection $this$toTypedArray$iv = ArraysKt.toList((Object[])queries);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.queries = thisCollection$iv.toArray(new RowMajorDataFrame.Query[0]);
        }

        @Override
        public boolean matches(R row) {
            for (RowMajorDataFrame.Query query : this.queries) {
                if (query.matches(row)) continue;
                return false;
            }
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ/\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ/\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ/\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ/\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ?\u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00052\u0006\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00028\u00022\u0006\u0010\u0011\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012JP\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00052\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00052\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005H\u0016JP\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00052\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00052\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$DefaultQueryBuilder;", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$QueryBuilder;", "<init>", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;)V", "equal", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "column", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "smallerThan", "smallerThanOrEqualTo", "greaterThan", "greaterThanOrEqualTo", "overlap", "start1", "end1", "start2", "end2", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "and", "q1", "q2", "or", "molap"})
    public final class DefaultQueryBuilder
    implements RowMajorDataFrame.QueryBuilder<R, C, V> {
        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> equal(C column, V value) {
            return new Equal(column, value);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> smallerThan(C column, V value) {
            return new SmallerThan(column, value, false);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> smallerThanOrEqualTo(C column, V value) {
            return new SmallerThan(column, value, true);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> greaterThan(C column, V value) {
            return new GreaterThan(column, value, false);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> greaterThanOrEqualTo(C column, V value) {
            return new GreaterThan(column, value, true);
        }

        @Override
        @NotNull
        public RowMajorDataFrame.Query<R, C, V> overlap(C start1, C end1, V start2, V end2) {
            return new Overlap(start1, end1, start2, end2);
        }

        @Override
        @Nullable
        public RowMajorDataFrame.Query<R, C, V> and(@NotNull RowMajorDataFrame.Query<R, C, V> q1, @NotNull RowMajorDataFrame.Query<R, C, V> q2) {
            Intrinsics.checkNotNullParameter(q1, (String)"q1");
            Intrinsics.checkNotNullParameter(q2, (String)"q2");
            return q1.and(q2);
        }

        @Override
        @Nullable
        public RowMajorDataFrame.Query<R, C, V> or(@NotNull RowMajorDataFrame.Query<R, C, V> q1, @NotNull RowMajorDataFrame.Query<R, C, V> q2) {
            Intrinsics.checkNotNullParameter(q1, (String)"q1");
            Intrinsics.checkNotNullParameter(q2, (String)"q2");
            return q1.or(q2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$Equal;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "column", "value", "<init>", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "Ljava/lang/Object;", "matches", "", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class Equal
    extends AbstractQuery {
        private final C column;
        @Nullable
        private final V value;

        public Equal(C column, V value) {
            this.column = column;
            this.value = value;
        }

        @Override
        public boolean matches(R row) {
            return this.value == null ? AbstractRowMajorDataFrame.this.getValueAt(row, this.column) == null : Intrinsics.areEqual(this.value, AbstractRowMajorDataFrame.this.getValueAt(row, this.column));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$GreaterThan;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "column", "value", "valueInclusive", "", "<init>", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;Ljava/lang/Object;Ljava/lang/Object;Z)V", "Ljava/lang/Object;", "matches", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class GreaterThan
    extends AbstractQuery {
        private final C column;
        @Nullable
        private final V value;
        private final boolean valueInclusive;

        public GreaterThan(C column, V value, boolean valueInclusive) {
            this.column = column;
            this.value = value;
            this.valueInclusive = valueInclusive;
        }

        @Override
        public boolean matches(R row) {
            boolean bl;
            if (this.value == null || !(this.value instanceof Comparable)) {
                bl = false;
            } else {
                Object v = this.value;
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Comparable<V of org.molap.dataframe.rowmajor.AbstractRowMajorDataFrame>");
                int compareTo = ((Comparable)v).compareTo(AbstractRowMajorDataFrame.this.getValueAt(row, this.column));
                bl = this.valueInclusive ? compareTo >= 0 : compareTo > 0;
            }
            return bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B?\u00126\u0010\u0003\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00050\u0004\"\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fR(\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\r"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$Or;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "queries", "", "Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "<init>", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;[Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;)V", "[Lorg/molap/dataframe/rowmajor/RowMajorDataFrame$Query;", "matches", "", "row", "(Ljava/lang/Object;)Z", "molap"})
    @SourceDebugExtension(value={"SMAP\nAbstractRowMajorDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractRowMajorDataFrame.kt\norg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$Or\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,272:1\n37#2:273\n36#2,3:274\n*S KotlinDebug\n*F\n+ 1 AbstractRowMajorDataFrame.kt\norg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$Or\n*L\n178#1:273\n178#1:274,3\n*E\n"})
    public final class Or
    extends AbstractQuery {
        @NotNull
        private final RowMajorDataFrame.Query<R, C, V>[] queries;

        public Or(RowMajorDataFrame.Query<R, C, V> ... queries) {
            Intrinsics.checkNotNullParameter(queries, (String)"queries");
            Collection $this$toTypedArray$iv = ArraysKt.toList((Object[])queries);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.queries = thisCollection$iv.toArray(new RowMajorDataFrame.Query[0]);
        }

        @Override
        public boolean matches(R row) {
            for (RowMajorDataFrame.Query query : this.queries) {
                if (!query.matches(row)) continue;
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\u0004\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$Overlap;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "start1", "end1", "start2", "end2", "<init>", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "Ljava/lang/Object;", "matches", "", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class Overlap
    extends AbstractQuery {
        private final C start1;
        private final C end1;
        @Nullable
        private final V start2;
        @Nullable
        private final V end2;

        public Overlap(C start1, C end1, V start2, V end2) {
            this.start1 = start1;
            this.end1 = end1;
            this.start2 = start2;
            this.end2 = end2;
        }

        @Override
        public boolean matches(R row) {
            boolean bl;
            if (this.start2 == null || !(this.start2 instanceof Comparable) || this.end2 == null || !(this.end2 instanceof Comparable)) {
                bl = false;
            } else {
                Object v = AbstractRowMajorDataFrame.this.getValueAt(row, this.start1);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Comparable<V of org.molap.dataframe.rowmajor.AbstractRowMajorDataFrame>");
                Comparable s1 = (Comparable)v;
                Object e1 = AbstractRowMajorDataFrame.this.getValueAt(row, this.end1);
                Object v2 = this.start2;
                Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Comparable<V of org.molap.dataframe.rowmajor.AbstractRowMajorDataFrame>");
                Comparable s2 = (Comparable)v2;
                Object e2 = this.end2;
                bl = s1.compareTo(e2) < 0 && s2.compareTo(e1) < 0;
            }
            return bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$SmallerThan;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame$AbstractQuery;", "Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;", "column", "value", "valueInclusive", "", "<init>", "(Lorg/molap/dataframe/rowmajor/AbstractRowMajorDataFrame;Ljava/lang/Object;Ljava/lang/Object;Z)V", "Ljava/lang/Object;", "matches", "row", "(Ljava/lang/Object;)Z", "molap"})
    public final class SmallerThan
    extends AbstractQuery {
        private final C column;
        @Nullable
        private final V value;
        private final boolean valueInclusive;

        public SmallerThan(C column, V value, boolean valueInclusive) {
            this.column = column;
            this.value = value;
            this.valueInclusive = valueInclusive;
        }

        @Override
        public boolean matches(R row) {
            boolean bl;
            if (this.value == null || !(this.value instanceof Comparable)) {
                bl = false;
            } else {
                Object v = this.value;
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Comparable<V of org.molap.dataframe.rowmajor.AbstractRowMajorDataFrame>");
                int compareTo = ((Comparable)v).compareTo(AbstractRowMajorDataFrame.this.getValueAt(row, this.column));
                bl = this.valueInclusive ? compareTo <= 0 : compareTo < 0;
            }
            return bl;
        }
    }
}

