/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter;

import com.macrofocus.common.math.MathKt;
import com.macrofocus.common.math.big.BigDecimal;
import com.macrofocus.common.math.big.MathContext;
import com.macrofocus.common.math.big.RoundingMode;
import com.macrofocus.common.units.Quantity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.datetime.DateTimeTz;
import org.molap.exporter.DataFrameOutput;
import org.molap.exporter.DataFrameWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u001c\u0010\u0013\u001a\u00020\r2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016JS\u0010\u0016\u001a\u00020\r\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u0018\"\u0004\b\u0002\u0010\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001c2\u0006\u0010\u001d\u001a\u0002H\u00172\u0006\u0010\u001e\u001a\u0002H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/molap/exporter/DelimitedDataFrameWriter;", "Lorg/molap/exporter/DataFrameWriter;", "output", "Lorg/molap/exporter/DataFrameOutput;", "delimiter", "", "newLine", "<init>", "(Lorg/molap/exporter/DataFrameOutput;Ljava/lang/String;Ljava/lang/String;)V", "row", "", "column", "start", "", "writeColumnName", "value", "hasMore", "", "includeType", "writeType", "cl", "Lkotlin/reflect/KClass;", "writeCell", "R", "C", "V", "", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "rowKey", "columnKey", "(Ljava/lang/Object;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "nextColumn", "nextRow", "close", "Companion", "molap"})
@SourceDebugExtension(value={"SMAP\nDelimitedDataFrameWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelimitedDataFrameWriter.kt\norg/molap/exporter/DelimitedDataFrameWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class DelimitedDataFrameWriter
implements DataFrameWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataFrameOutput output;
    @NotNull
    private final String delimiter;
    @NotNull
    private final String newLine;
    private int row;
    private int column;

    public DelimitedDataFrameWriter(@NotNull DataFrameOutput output2, @NotNull String delimiter, @NotNull String newLine) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        Intrinsics.checkNotNullParameter((Object)newLine, (String)"newLine");
        this.output = output2;
        this.delimiter = delimiter;
        this.newLine = newLine;
    }

    @Override
    public void start() {
    }

    @Override
    public void writeColumnName(@Nullable String value, boolean hasMore) {
        Object value2 = value;
        if (value2 != null) {
            if (StringsKt.contains$default((CharSequence)((CharSequence)value2), (CharSequence)this.delimiter, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)value2), (CharSequence)"\"", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)value2), (CharSequence)"\n", (boolean)false, (int)2, null)) {
                CharSequence charSequence = (CharSequence)value2;
                Regex regex = new Regex("\"");
                String string = "\"\"";
                value2 = "\"" + regex.replace(charSequence, string) + "\"";
            }
            this.output.write((String)value2);
        }
        this.nextColumn(hasMore);
    }

    @Override
    public boolean includeType() {
        return false;
    }

    @Override
    public void writeType(@NotNull KClass<?> cl, boolean hasMore) {
        Intrinsics.checkNotNullParameter(cl, (String)"cl");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R, C, V> void writeCell(@Nullable Object value, @NotNull DataFrame<R, C, V> dataFrame, R rowKey, C columnKey) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (value != null) {
            HexFormat.Builder builder;
            Object object;
            Object str = null;
            if (value instanceof Number) {
                v0 = Companion.numberToString((Number)value);
            } else if (value instanceof Quantity) {
                v0 = Companion.numberToString(((Quantity)value).getAmount());
            } else if (value instanceof byte[]) {
                void $this$writeCell_u24lambda_u240;
                builder = object = new HexFormat.Builder();
                byte[] byArray = (byte[])value;
                boolean bl = false;
                $this$writeCell_u24lambda_u240.getNumber().setPrefix("0x");
                v0 = HexExtensionsKt.toHexString((byte[])byArray, (HexFormat)object.build());
            } else {
                v0 = str = value instanceof DateTimeTz ? ((DateTimeTz)value).toISOString() : value.toString();
            }
            if (StringsKt.contains$default((CharSequence)((CharSequence)str), (CharSequence)this.delimiter, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)str), (CharSequence)"\"", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)str), (CharSequence)"\n", (boolean)false, (int)2, null)) {
                object = (CharSequence)str;
                builder = new Regex("\"");
                String string = "\"\"";
                str = "\"" + builder.replace((CharSequence)object, string) + "\"";
            }
            this.output.write((String)str);
        }
    }

    @Override
    public void nextColumn(boolean hasMore) {
        int n = this.column;
        this.column = n + 1;
        if (hasMore) {
            this.output.write(this.delimiter);
        }
    }

    @Override
    public void nextRow() {
        this.column = 0;
        int n = this.row;
        this.row = n + 1;
        this.output.write(this.newLine);
    }

    @Override
    public void close() {
        this.output.close();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/molap/exporter/DelimitedDataFrameWriter$Companion;", "", "<init>", "()V", "numberToString", "", "value", "", "molap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String numberToString(@Nullable Number value) {
            if (value == null) {
                return "";
            }
            if (value instanceof Double) {
                double v = value.doubleValue();
                if (MathKt.isNaN((double)v) || MathKt.isInfinite((double)v)) {
                    return String.valueOf(v);
                }
                return BigDecimal.Companion.of(v, new MathContext(15, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
            }
            if (value instanceof Float) {
                float v = value.floatValue();
                if (MathKt.isNaN((float)v) || MathKt.isInfinite((float)v)) {
                    return String.valueOf(v);
                }
                return BigDecimal.Companion.of((double)v, new MathContext(6, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
            }
            if (value instanceof Long) {
                long v = value.longValue();
                return String.valueOf(v);
            }
            if (value instanceof Integer) {
                int v = value.intValue();
                return String.valueOf(v);
            }
            if (value instanceof Byte) {
                byte v = value.byteValue();
                return String.valueOf(v);
            }
            if (value instanceof Short) {
                short v = value.shortValue();
                return String.valueOf(v);
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toPlainString();
            }
            return value.toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

