/*
 * Decompiled with CFR 0.152.
 */
package org.molap.subset;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.molap.subset.DistributionDimension;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B/\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0006R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/molap/subset/AutoSigmaDistributionStrategy;", "Value", "Lorg/molap/subset/DistributionDimension$DistributionStrategy;", "", "numberOfBins", "minValue", "", "mean", "stdDev", "maxValue", "<init>", "(IDDDD)V", "getMinValue", "()D", "getMaxValue", "numberOfBinsAbove", "numberOfBinsBelow", "lsl", "usl", "getBinStartValue", "bin", "getBinEndValue", "isBinnable", "", "value", "(Ljava/lang/Object;)Z", "valueToBin", "(Ljava/lang/Object;)Ljava/lang/Integer;", "getSigmaLevel", "v", "molap"})
public final class AutoSigmaDistributionStrategy<Value>
implements DistributionDimension.DistributionStrategy<Value, Integer> {
    private final double minValue;
    private final double mean;
    private final double stdDev;
    private final double maxValue;
    private final int numberOfBinsAbove;
    private final int numberOfBinsBelow;
    private final int numberOfBins;
    private final double lsl;
    private final double usl;

    public AutoSigmaDistributionStrategy(int numberOfBins, double minValue, double mean, double stdDev, double maxValue) {
        this.minValue = minValue;
        this.mean = mean;
        this.stdDev = stdDev;
        this.maxValue = maxValue;
        this.lsl = this.getMinValue();
        this.usl = this.getMaxValue();
        this.numberOfBinsAbove = (int)Math.ceil((this.getMaxValue() - this.mean) / this.stdDev);
        this.numberOfBinsBelow = (int)Math.ceil((this.mean - this.getMinValue()) / this.stdDev);
        this.numberOfBins = this.numberOfBinsAbove + this.numberOfBinsBelow;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public double getBinStartValue(int bin) {
        return (double)bin * ((this.getMaxValue() - this.getMinValue()) / (double)this.numberOfBins) + this.getMinValue();
    }

    @Override
    public double getBinEndValue(int bin) {
        return (double)(bin + 1) * ((this.getMaxValue() - this.getMinValue()) / (double)this.numberOfBins) + this.getMinValue();
    }

    @Override
    public boolean isBinnable(Value value) {
        return value != null && value instanceof Number;
    }

    @Override
    @NotNull
    public Integer valueToBin(Value value) {
        if (value instanceof Number) {
            double v = ((Number)value).doubleValue();
            return this.getSigmaLevel(v);
        }
        return -3;
    }

    public final int getSigmaLevel(double v) {
        if (v < this.getMinValue()) {
            return -1;
        }
        if (v > this.getMaxValue()) {
            return -2;
        }
        double sigma = (v - this.mean) / this.stdDev;
        return sigma >= 0.0 ? (int)sigma + this.numberOfBinsBelow : (int)sigma + (this.numberOfBinsBelow - 1);
    }
}

