package org.molap.aggregates.aggregation

import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.dataframe.ReMappedDataFrame
import org.molap.dataframe.ReMappedRecipe
import org.molap.index.DefaultUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.reflect.KClass

class DataFrameAggregation : AbstractAggregation<Any>() {
    override val type: KClass<Any>
        get() = Any::class

    override fun compute(cuboid: Cuboid?, group: Group?): Any {
        return cuboid!!.getAggregate(group, func)!!
    }

    override fun toString(): String {
        return "DataFrame"
    }

    companion object {
        private val func: AggregateSeriesFunction<Any?> = object : AggregateSeriesFunction<Any?> {
            override fun aggregate(cuboid: Cuboid, rows: Iterable<Any?>?): Any {
                return ReMappedDataFrame(cuboid.cube!!.dataFrame, object : ReMappedRecipe<Any?, Any?> {
                    override fun buildRowIndex(): UniqueIndex<Any?> {
                        return DefaultUniqueIndex(rows!!.toList().toTypedArray())
                    }

                    override fun buildColumnIndex(): UniqueIndex<Any?> {
                        return cuboid.cube!!.dataFrame.columnIndex
                    }
                })
            }
        }
    }
}