/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation


import org.molap.aggregates.cube.DistributiveStatistics
import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.series.Series
import kotlin.reflect.KClass

class DistributiveStatisticsAggregation(private val column: Series<Any?, Any?>) : AbstractAggregation<Any?>() {
    override val type: KClass<Any>
        get() = DistributiveStatistics::class as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        return cuboid!!.getDistributiveStatistics(group, column, null)
    }

    val value: DistributiveStatistics
        get() = DistributiveStatistics(column)

    override fun toString(): String {
        return "DistributiveStatistics(" + column.name + ")"
    }
}