/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation


import org.molap.aggregates.cube.DistributiveStatistics
import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.series.Series
import kotlin.reflect.KClass

class MinAggregation(private val column: Series<Any?, Any?>) : AbstractAggregation<Any?>() {
    override val type: KClass<Any>
        get() = column.type as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        val distributiveStatistics = cuboid!!.getDistributiveStatistics(group, column, null)
        return distributiveStatistics!!.minimum
    }

    val value: Number?
        get() {
            val distributiveStatistics = DistributiveStatistics(column)
            return distributiveStatistics.minimum
        }

    override fun toString(): String {
        return "Min(" + column.name + ")"
    }
}