/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.query

import com.macrofocus.common.collection.Collections
import org.molap.aggregates.aggregation.Aggregation
import org.molap.aggregates.cube.ArrayGroup
import org.molap.aggregates.cube.Dimensions
import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid

class CuboidsQuery(cuboids: Array<out Cuboid>?, vararg aggregations: Aggregation<Any?>) : AbstractQuery() {
    private val cuboids: Array<out Cuboid>?
    override val aggregations: Array<Aggregation<Any?>>
    override var groups: MutableList<Group>? = null
        get() {
            if (isDirty) {
                run()
            }
            return field
        }
    override var dimensions: Dimensions? = null
        get() {
            if (isDirty) {
                run()
            }
            return field
        }

    private fun run() {
        isDirty = false
        val columns: MutableSet<Any?> = HashSet<Any?>()
        for (cuboid in cuboids!!) {
            val d: Dimensions? = cuboid.dimensions
            Collections.addAll<Any>(columns, d!!.path)
        }
        dimensions = Dimensions.create(*columns.toTypedArray())
        groups = ArrayList<Group>()
        for (cuboid in cuboids) {
            for (group in cuboid.groups!!) {
                groups!!.add(CuboidGroup(cuboid, dimensions, group))
            }
        }
    }

    override fun getValue(path: Group?, aggregation: Aggregation<Any?>): Any? {
        return aggregation.compute((path as CuboidGroup).cuboid, (path as CuboidGroup).originalGroup)
    }

    override val cuboid: Cuboid?
        get() = null

    override fun setDice(valuesSets: Set<Any?>) {
        throw UnsupportedOperationException()
    }

    private class CuboidGroup(cuboid: Cuboid, dimensions: Dimensions?, group: Group) : ArrayGroup(group.path) {
        val cuboid: Cuboid
        private val dimensions: Dimensions?
        private val group: Group
        val originalGroup: Group
            get() = group

        // Find column index
        override val path: Array<Any?>
            get() {
                val path = arrayOfNulls<Any>(dimensions!!.path.size)
                for (i in 0 until dimensions.path.size) {
                    val column: Any? = dimensions.path.get(i)

                    // Find column index
                    val index: Int? = cuboid.dimensions?.getIndex(column)
                    if (index != null) {
                        path[i] = group.getPath(index)
                    } else {
                        path[i] = Cuboid.ALL
                    }
                }
                return path
            }

        override fun getPath(i: Int): Any? {
            return path[i]
        }

        init {
            this.cuboid = cuboid
            this.dimensions = dimensions
            this.group = group
        }
    }

    init {
//        assert(cuboids != null)
        this.cuboids = cuboids
        this.aggregations = aggregations as Array<Aggregation<Any?>>
    }
}