package org.molap.dataframe

import org.molap.index.UniqueIndex
import kotlin.jvm.JvmOverloads
import kotlin.reflect.KClass

class DelegatedDataFrame<R, C, V> @JvmOverloads constructor(delegate: DataFrame<R, C, V>? = EmptyDataFrame.instance as DataFrame<R, C, V>) :
    AbstractDataFrame<R, C, V>() {
    private var delegate: DataFrame<R, C, V>? = null

    val dataFrameListener: DataFrameListener<R, C> = object : DataFrameListener<R, C> {
        override fun dataFrameChanged(event: DataFrameEvent<R, C>) {
            notifyDataFrameChanged(event!!)
        }
    }

    init {
        setDelegate(delegate)
    }

    fun setDelegate(delegate: DataFrame<R, C, V>?) {
        if (this.delegate != null) {
            this.delegate!!.removeDataFrameListener(dataFrameListener)
        }

        this.delegate = delegate

        this.delegate!!.addWeakDataFrameListener(dataFrameListener)

        notifyDataFrameChanged(DataFrameEvent(null, null, true))
    }

    override fun getColumnName(c: C): String? {
        return delegate!!.getColumnName(c)
    }

    override fun getColumnClass(c: C): KClass<*> {
        return delegate!!.getColumnClass(c)
    }

    override fun getRowClass(row: R): KClass<*>? {
        return delegate!!.getRowClass(row)
    }

    override fun getValueAt(r: R, c: C): V {
        return delegate!!.getValueAt(r, c)
    }

    override val rowIndex: UniqueIndex<R>
        get() = delegate!!.rowIndex

    override val columnIndex: UniqueIndex<C>
        get() = delegate!!.columnIndex
}
