/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation


import org.molap.aggregates.cuboid.Cuboid
import org.molap.aggregates.cube.DistributiveStatistics
import org.molap.aggregates.cube.Group

import org.molap.series.Series
import kotlin.reflect.KClass

class FirstAggregation(private val column: Series<Any?, Any?>) : AbstractAggregation<Any?>() {
    override val type: KClass<Any>
        get() = column.type as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        val distinct: Set<Any?>? = cuboid!!.getDistinct(group, column)
        return if (distinct != null && !distinct.isEmpty()) {
            distinct.iterator().next()
        } else {
            null
        }
    }

    override fun toString(): String {
        return "First(" + column.name + ")"
    }
}