package org.molap.dataframe

import org.molap.index.DefaultUniqueIndex
import org.molap.index.IntegerRangeUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.math.abs
import kotlin.random.Random
import kotlin.reflect.KClass

class RandomDataFrame(clusterCount: Int, rowCount: Int, columnCount: Int) : AbstractDataFrame<Int, String, Double>() {
    val columnNames: Array<String?>
    val data: Array<Array<Double?>>

    init {
        val random: Random = Random(0)

        // Column names
        columnNames = arrayOfNulls<String>(columnCount)
        for (c in 0 until columnCount) {
            columnNames[c] = c.toString()
        }

        // Cluster centroid
        val clusters = Array(clusterCount) {
            DoubleArray(
                columnCount
            )
        }
        for (r in 0 until clusterCount) {
            for (c in 0 until columnCount) {
                clusters[r][c] = random.nextDouble()
            }
        }


        // Data values
        data = Array(rowCount) {
            arrayOfNulls<Double>(
                columnCount
            )
        }
        for (r in 0 until rowCount) {
            val cluster = abs((random.nextInt() % clusterCount).toDouble()).toInt()
            for (c in 0 until columnCount) {
                val centroid = clusters[cluster][c]

                // ToDo: no implementation of nextGaussian() in Kotlin?
//                data[r][c] = centroid + (random.nextGaussian() / 30)
                data[r][c] = centroid + (random.nextDouble() / 30)
            }
        }
    }

    override val rowIndex: UniqueIndex<Int> by lazy { IntegerRangeUniqueIndex(0, rowCount - 1) }
    override val columnIndex: UniqueIndex<String> by lazy {
        val names: Array<String?> = arrayOfNulls<String>(columnNames.size)
        for (c in columnNames.indices) {
            names[c] = columnNames.get(c)
        }
        DefaultUniqueIndex<String>(*names.requireNoNulls())
    }

    override fun getRowClass(row: Int): KClass<*>? {
        return Any::class
    }

    override fun getColumnClass(column: String): KClass<out Any> {
        return Double::class
    }

    override fun getValueAt(row: Int, column: String): Double {
        return data.get(rowIndex.getAddress(row)).get(columnIndex.getAddress(column))!!
    }
}