package org.molap.network

import kotlin.js.JsExport

/**
 * An undirected graph
 */
@JsExport
interface Graph<Vertex, Edge> {
//    val verticesCount: Int
    val nodes: Iterable<Vertex>
//    val verticesIndex: UniqueIndex<Vertex>?
    val links: Iterable<Edge>

    fun target(link: Edge, node: Vertex) : Vertex

    fun getFrom(link: Edge): Vertex
    fun getTo(link: Edge): Vertex

    fun getLink(from : Vertex, to: Vertex) : Edge?

    fun getLinks(from : Vertex) : Iterable<Edge>

    fun getNeighbors(from : Vertex) : Iterable<Vertex>

//    fun getReverse(edge: Edge): Edge
//    fun getEdges(vertex: Vertex): Iterable<Edge>?
//    fun getEdgesTo(to: Vertex): Iterable<Edge>?
//    fun getEdgesFrom(from: Vertex): Iterable<Edge>?
//    fun getEdgesFromCount(from: Vertex): Int
//    val maxEdgesCount: Int
}