package org.molap.series

abstract class AbstractTimeSeries<K, V> : AbstractSeries<K, V>(), TimeSeries<K, V> {
    override fun getTime(mode: TimeSeries.TimeMode, key: K): Long {
        return when (mode) {
            TimeSeries.TimeMode.Absolute -> getAbsoluteTime(key)
            TimeSeries.TimeMode.Relative -> getRelativeTime(key)
            TimeSeries.TimeMode.Sequential -> getSequantialTime(key)
            else -> throw IllegalArgumentException()
        }
    }
}
