package org.molap.series

import org.molap.index.DefaultUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.reflect.KClass

class IndexedSeries<K, V> : AbstractSeries<K, V> {
    private val values: Array<V>
    private val index: UniqueIndex<K>
    override val name: Any?

    constructor(name: Any?, values: Array<V>, keys: Array<K>) {
        this.name = name
        this.values = values
        index = DefaultUniqueIndex<K>(UniqueIndex.Duplicate.UseFirstWarn, *keys)
    }

    constructor(name: Any?, values: Array<V>, index: UniqueIndex<K>) {
        this.name = name
        this.values = values
        this.index = index
    }

//    override val type: KClass<out Any>
//        get() {
//            val component1 = values.component1()
//            return if(component1 != null) { component1::class} else { throw RuntimeException() }
//        }

    override val type: KClass<out Any>
        get() = Any::class

    override fun get(key: K): V {
        val index: Int = index.getAddress(key)
//        return if (index >= 0) {
            return values[index]
//        } else {
//            null
//        }
    }

    override fun getKey(i: Int): K {
        return index.getKey(i)
    }

    override fun size(): Int {
        return index.size
    }

    override fun getAddress(key: K): Int {
        return index.getAddress(key)
    }

    override fun keys(): Iterable<K> {
        return index.keys()
    }

    fun head(count: Int): Series<K, V> {
        return IndexedSeries<K, V>("head($name)", values, index.head(count))
    }

    fun tail(count: Int): Series<K, V> {
        return IndexedSeries<K, V>("tail($name)", values, index.tail(count))
    }
}
