package org.molap.series

import kotlin.random.Random

//fun <V> seriesOf(name: Any, sequence: Sequence<V>) : Series<Int,V> {
//    return DefaultSeries<V>(name, sequence.toList().toTypedArray())
//}
//
//fun <V> seriesOf(name: Any, sequence: List<V>) : Series<Int,V> {
//    val array: Array<V> = sequence.toTypedArray()
//    return DefaultSeries<V>(name, sequence.toTypedArray())
//}

fun <V> seriesOf(name: Any, vararg values : V) : ImmutableSeries<V> {
    return ImmutableSeries(name, values)
}

fun seriesOf(name: Any, vararg values : Double?) : ImmutableSeries<Double?> {
    return ImmutableSeries(name, values)
}

fun seriesOf(name: Any, vararg values : Double) : DoubleSeries {
    return DoubleSeries(name, values)
}

fun seriesOf(name: Any, size : Int) : ImmutableSeries<Double> {
    return seriesOf(name, size, {
        Random.nextDouble()
    })
}


fun randomDoubleSeriesOf(name: Any, size : Int) : DoubleSeries {
    return doubleSeriesOf(name, size, {
        Random.nextDouble()
    })
}

fun doubleSeriesOf(name: Any, size: Int, init: (Int) -> Double) : DoubleSeries {
    val array = DoubleArray(size, {
        init.invoke(it)
    })
    return DoubleSeries(name, array)
}

inline fun <reified V> seriesOf(name: Any, size: Int, init: (Int) -> V) : ImmutableSeries<V> {
    val array = Array(size, {
        init.invoke(it)
    })
    return ImmutableSeries(name, array)
}