/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

/**
 * Created by luc on 01/07/16.
 */
class FixedSigmaDistributionStrategy<Value>(
    numberOfBins: Int,
    minValue: Double,
    private val mean: Double,
    private val stdDev: Double,
    maxValue: Double
) : DistributionDimension.DistributionStrategy<Value, Int> {
    override val minValue: Double
    override val maxValue: Double
    private val numberOfBinsAbove: Int
    private val numberOfBinsBelow: Int
    private val numberOfBins: Int
    override fun getBinStartValue(bin: Int): Double {
        return bin * ((maxValue - minValue) / numberOfBins) + minValue
    }

    override fun getBinEndValue(bin: Int): Double {
        return (bin + 1) * ((maxValue - minValue) / numberOfBins) + minValue
    }

    override fun isBinnable(value: Value): Boolean {
        return value != null && (value is Number) // || value is java.util.Date)
    }

    override fun valueToBin(value: Value): Int {
//        return if (value != null) {
//            if (value is java.util.Date) {
//                val v: Double = (value as java.util.Date).getTime().toDouble()
//                getSigmaLevel(v)
//            } else
//                if (value is Number) {
                val v = (value as Number).toDouble()
                return getSigmaLevel(v)
//            } else {
//                null
//            }
//        } else {
//            null
//        }
    }

    fun getSigmaLevel(v: Double): Int {
        val sigma = (v - mean) / stdDev
        return if (sigma >= 0) {
            sigma.toInt() + numberOfBinsBelow
        } else {
            sigma.toInt() + (numberOfBinsBelow - 1)
        }
        //        if(sigma >= 0) {
//            return (int) Math.ceil(sigma) + numberOfBinsBelow;
//        } else {
//            return (int) Math.floor(sigma) + numberOfBinsBelow;
//        }

//        if (v == maxValue) return (numberOfBins - 1);
//        if (v == minValue) return 0;
//        return (int) ((v - minValue) / ((maxValue - minValue) / numberOfBins));
    }

    init {
        this.minValue = mean - numberOfBins * stdDev
        this.maxValue = mean + numberOfBins * stdDev
        numberOfBinsAbove = numberOfBins
        numberOfBinsBelow = numberOfBins
        this.numberOfBins = numberOfBinsAbove + numberOfBinsBelow
    }
}