/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import kotlin.math.max
import kotlin.math.min

object SortedArraySetOperations {
    fun diffSortedTIntArrays(size: Int, indices: IntArray): IntArray {
        val result = IntArray(size - indices.size)
        var r = 0
        var j = 0
        for (i in 0 until size) {
            if (j < indices.size && indices[j] <= i) {
                j++
            } else {
                result[r++] = i
            }
        }
        return result
    }

    fun diffSortedTIntList(size: Int, indices: IntArray): IntArray {
        val result: com.macrofocus.common.collection.TIntList = com.macrofocus.common.collection.TIntArrayList(size - indices.size)
        var j = 0
        for (i in 0 until size) {
            if (j < indices.size && indices[j] <= i) {
                j++
            } else {
                result.add(i)
            }
        }
        return result.toIntArray()
    }

    /**
     * Relative complement of b in a (or set-theoretic difference of a and b)
     *
     * @param a
     * @param b
     * @return
     */
    fun diffSortedTIntList(a: IntArray?, b: IntArray?): IntArray? {
        return if (a != null) {
            if (b != null) {
                val result: com.macrofocus.common.collection.TIntList = com.macrofocus.common.collection.TIntArrayList(max(a.size, b.size))
                var i = 0
                var j = 0
                while (i < a.size && j < b.size) {
                    if (a[i] < b[j]) {
                        result.add(a[i])
                        ++i
                    } else if (a[i] > b[j]) {
                        ++j
                    } else {
                        ++i
                        ++j
                    }
                }
                while (i < a.size) {
                    result.add(a[i])
                    ++i
                }
                result.toIntArray()
            } else {
                a
            }
        } else {
            null
        }
    }

    fun unionSortedTIntList(a: IntArray, b: IntArray): IntArray {
        val answer: com.macrofocus.common.collection.TIntList = com.macrofocus.common.collection.TIntArrayList(max(a.size, b.size))
        var i = 0
        var j = 0
        var tmp: Int
        while (i < a.size && j < b.size) {
            tmp = if (a[i] < b[j]) a[i++] else b[j++]
            while (i < a.size && a[i] == tmp) {
                i++
            }
            while (j < b.size && b[j] == tmp) {
                j++
            }
            answer.add(tmp)
        }
        while (i < a.size) {
            tmp = a[i++]
            while (i < a.size && a[i] == tmp) {
                i++
            }
            answer.add(tmp)
        }
        while (j < b.size) {
            tmp = b[j++]
            while (j < b.size && b[j] == tmp) {
                j++
            }
            answer.add(tmp)
        }
        return answer.toIntArray()
    }

    fun unionSortedArrays(a: IntArray?, b: IntArray?): IntArray {
//        assert(a != null)
//        assert(b != null)
        val answer = IntArray(a!!.size + b!!.size)
        var i = 0
        var j = 0
        var k = 0
        var tmp: Int
        while (i < a.size && j < b.size) {
            tmp = if (a[i] < b[j]) a[i++] else b[j++]
            while (i < a.size && a[i] == tmp) {
                i++
            }
            while (j < b.size && b[j] == tmp) {
                j++
            }
            answer[k++] = tmp
        }
        while (i < a.size) {
            tmp = a[i++]
            while (i < a.size && a[i] == tmp) {
                i++
            }
            answer[k++] = tmp
        }
        while (j < b.size) {
            tmp = b[j++]
            while (j < b.size && b[j] == tmp) {
                j++
            }
            answer[k++] = tmp
        }
        return com.macrofocus.common.collection.copyOf(answer, k)
    }

    fun intersectSortedArrays(a: IntArray?, b: IntArray?): IntArray {
//        assert(a != null)
//        assert(b != null)
        val c = IntArray(min(a!!.size, b!!.size))
        var ai = 0
        var bi = 0
        var ci = 0
        while (ai < a.size && bi < b.size) {
            if (a[ai] < b[bi]) {
                ai++
            } else if (a[ai] > b[bi]) {
                bi++
            } else {
                if (ci == 0 || a[ai] != c[ci - 1]) {
                    c[ci++] = a[ai]
                }
                ai++
                bi++
            }
        }
        return com.macrofocus.common.collection.copyOfRange(c, 0, ci)
    }
}