/*
 * Copyright (c) 2009 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.data;

import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.data.column.DataModelColumnModel;
import com.macrofocus.data.row.DataModelRowModel;
import com.macrofocus.data.row.RowModel;

import java.util.Enumeration;
import java.util.Locale;

public abstract class AbstractDataModel implements DataModel {
    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < getColumnCount(); i++) {
            final Object columnName = getColumnName(i);
            if (columnName != null) {
                if (columnName instanceof String && name instanceof String) {
                    if (((String) columnName).trim().equals(((String) name).trim())) {
                        index = i;
                        break;
                    }
                } else {
                    if (columnName.equals(name)) {
                        index = i;
                        break;
                    }
                }
            }
        }
        return index;
    }

    @Override
    public int getLocalizedColumnIndex(Object name, Locale locale) {
//        for (Enumeration enumeration = LocaleHelper.getCandidates(locale); enumeration.hasMoreElements(); ) {
//            String s2 = (String) enumeration.nextElement();
//            String localizedName = name + s2;
            int index = getColumnIndex(name);
            if (index >= 0)
                return index;
//        }

        return -1;
    }

    @Override
    public RowModel getRowModel(final int row) {
        return new DataModelRowModel(this, row);
    }

    @Override
    public ColumnModel getColumnModel(final int column) {
        if (column >= 0) {
            return new DataModelColumnModel(this, column);
        } else {
            return null;
        }
    }

    public String toString() {
        return getClass().getName() + "[columnCount=" + getColumnCount() + ",rowCount=" + getRowCount() + "]";
    }
}
