package com.macrofocus.data;

import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.data.row.RowModel;

import java.util.Locale;

/**
 * Responsible for holding tablular data.
 */
public interface DataModel {
    /**
     * Tells if data is available at the specified row and column.
     *
     * @param row    an <code>int</code> value
     * @param column an <code>int</code> value
     * @return a <code>boolean</code> value
     */
    boolean isAvailable(int row, int column);

    /**
     * Returns the object at the specified row and column.
     *
     * @param row    an <code>int</code> value
     * @param column an <code>int</code> value
     * @return an <code>Object</code> value
     */
    Object getValueAt(int row, int column);

    /**
     * Returns the name of the column at the specified index.
     *
     * @param column an <code>int</code> value
     * @return an <code>Object</code> value
     */
    Object getColumnName(int column);

    /**
     * Returns the index of the specified column name.
     *
     * @param name an <code>Object</code> value
     * @return an <code>int</code> value
     */
    int getColumnIndex(Object name);

    /**
     * Returns the index of the specified column name.
     *
     * @param name   an <code>Object</code> value
     * @param locale a <code>Locale</code value
     * @return an <code>int</code> value
     */
    int getLocalizedColumnIndex(Object name, Locale locale);

    /**
     * Returns the <code>Class</code> objects in the specified column are instance of.
     *
     * @param column an <code>int</code> value
     * @return a <code>Class</code> value
     */
    Class getColumnClass(int column);

    /**
     * Returns the number of rows.
     *
     * @return an <code>int</code> value
     */
    int getRowCount();

    /**
     * Returns the number of columns.
     *
     * @return an <code>int</code> value
     */
    int getColumnCount();

    RowModel getRowModel(int row);

    ColumnModel getColumnModel(int column);

//    public void setObject(int row, int column, Object value);
//
//    public void addColumnModel(ColumnModel columnModel);
//
//    public void addRow(RowModel rowModel);
//
//    public void insertRow(int row, RowModel rowModel);
//
//    public void insertColumn(int row, ColumnModel columnModel);
//
//    public void moveRow(int startIndex, int endIndex, int toIndex);
//
//    public void moveColumn(int startIndex, int endIndex, int toIndex);
//
//    public void removeRow(int row);
//
//    public void removeColumn(int column);
//
//    public boolean isOjectEditable(int row, int column);
}
