/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.data

import org.molap.dataframe.AbstractDataFrame
import org.molap.dataframe.DataFrame
import org.molap.dataframe.MutableDataFrame
import org.molap.index.DefaultUniqueIndex
import org.molap.index.IntegerRangeUniqueIndex
import org.molap.index.MultiKey
import org.molap.index.UniqueIndex
import org.molap.series.AbstractSeries
import org.molap.series.Series
import kotlin.reflect.KClass

/**
 * Converts a TableModel into a DataFrame.
 */
class DataModelDataFrame(private val tableModel: DataModel) : AbstractDataFrame<Int, String?, Any?>(),
    MutableDataFrame<Int, String?, Any?> {
    override val rowIndex: UniqueIndex<Int> by lazy {
        IntegerRangeUniqueIndex(0, tableModel.getRowCount() - 1)
    }
    override val columnIndex: UniqueIndex<String?> by lazy {
        val names = arrayOfNulls<String>(tableModel.getColumnCount())

        for (c in 0..<tableModel.getColumnCount()) {
            names[c] = tableModel.getColumnName(c).toString()
        }

        DefaultUniqueIndex<String?>(*names)
    }

    override fun getRowClass(row: Int): KClass<*> {
        return Any::class
    }

    override fun getColumnClass(column: String?): KClass<*> {
        return tableModel.getColumnClass(columnIndex.getAddress(column)).kotlin
    }

    override fun getValueAt(row: Int, column: String?): Any? {
        return tableModel.getValueAt(row, columnIndex.getAddress(column))
    }

    override fun setValueAt(row: Int, column: String?, value: Any?) {
    }

    override fun rows(): Iterable<Int> {
        return rowIndex.keys()
    }

    override fun columns(): Iterable<String?> {
        return columnIndex.keys()
    }

    override fun getRowKey(index: Int): Int {
        return rowIndex.getKey(index)
    }

    override fun getColumnKey(index: Int): String? {
        return columnIndex.getKey(index)
    }

    override fun getRowAddress(row: Int): Int {
        return rowIndex.getAddress(row)
    }

    override fun getColumnAddress(column: String?): Int {
        return columnIndex.getAddress(column)
    }

    override val rowCount: Int
        get() = tableModel.getRowCount()

    override val columnCount: Int
        get() = tableModel.getColumnCount()

    override fun reindexRowsUsingColumn(column: String?): MutableDataFrame<Any?, String?, Any?>? {
        TODO("Not yet implemented")
    }

    override fun reindexRowsUsingColumns(vararg rows: String?): MutableDataFrame<MultiKey?, String?, Any?>? {
        TODO("Not yet implemented")
    }
}
