package com.macrofocus.data.column;

public abstract class AbstractColumnModel<O> implements ColumnModel<O> {
    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setObject(int index, O value) {
        throw new RuntimeException("Operation not allowed");
    }

    @Override
    public int getObjectCount() {
        return getRowCount();
    }

    public String toString() {
        String str = this.getClass().getName() + "[";
        for (int i = 0; i < getRowCount(); i++) {
            if (isAvailable(i)) {
                str = str + getObject(i);
            } else {
                str = str + "NaN";
            }
            if (i < getRowCount() - 1) {
                str = str + ", ";
            }
        }
        return str + "]";
    }
}
