package com.macrofocus.data.column;

import com.macrofocus.data.DataModel;

public class DataModelColumnModel<O> extends AbstractColumnModel<O> {
    public DataModelColumnModel(final DataModel dataModel, final int column) {
        this.dataModel = dataModel;
        this.column = column;
    }

    @Override
    public boolean isAvailable(final int row) {
        return dataModel.isAvailable(row, column);
    }

    @Override
    public O getObject(final int row) {
        return (O) dataModel.getValueAt(row, column);
    }

    @Override
    public Class getMembership() {
        return dataModel.getColumnClass(column);
    }

    @Override
    public Object getName() {
        return dataModel.getColumnName(column);
    }

    @Override
    public int getRowCount() {
        return dataModel.getRowCount();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DataModelColumnModel)) return false;

        final DataModelColumnModel dataModelColumnModel = (DataModelColumnModel) o;

        if (column != dataModelColumnModel.column) return false;
        return dataModel != null ? dataModel.equals(dataModelColumnModel.dataModel) : dataModelColumnModel.dataModel == null;
    }

    public int hashCode() {
        int result;
        result = column;
        result = 29 * result + (dataModel != null ? dataModel.hashCode() : 0);
        return result;
    }

    private final int column;
    private final DataModel dataModel;
}
