package com.macrofocus.data.column;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SimpleColumnModel<O> extends AbstractColumnModel<O> implements Externalizable {
    static final long serialVersionUID = 8291048985079302622L;

    public SimpleColumnModel() {
        this.name = null;
        this.membership = Object.class;
        this.objects = new Object[0];
        this.isEditable = false;
    }

    public SimpleColumnModel(final ColumnModel columnModel) {
        this.name = columnModel.getName();
        this.membership = columnModel.getMembership();
        this.objects = new Object[columnModel.getRowCount()];
        for (int i = 0; i < objects.length; i++) {
            if (columnModel.isAvailable(i)) {
                this.objects[i] = columnModel.getObject(i);
            } else {
                this.objects[i] = null;
            }
        }
        this.isEditable = columnModel.isEditable();
    }

    public SimpleColumnModel(final Object name, final Class membership, final Object[] objects) {
        this(name, membership, objects, false);
    }

    public SimpleColumnModel(final Object name, final Class membership, final Object[] objects, boolean isEditable) {
        this.name = name;
        this.membership = membership;
        this.objects = objects;
        this.isEditable = isEditable;
    }

    @Override
    public boolean isAvailable(final int index) {
        return objects[index] != null;
    }

    @Override
    public O getObject(final int index) {
        return (O) objects[index];
    }

    @Override
    public Object getName() {
        return name;
    }

    @Override
    public Class getMembership() {
        return membership;
    }

    @Override
    public int getRowCount() {
        return objects.length;
    }

    @Override
    public boolean isEditable() {
        return isEditable;
    }

    @Override
    public void setObject(int index, O value) {
        objects[index] = value;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeInt(getRowCount());
        out.writeObject(getName());
        out.writeObject(getMembership());
        out.writeBoolean(isEditable());
        for (int row = 0; row < getRowCount(); row++) {
            out.writeBoolean(isAvailable(row));
        }
        final Class cl = getMembership();
        if (cl == Double.class) {
            for (int row = 0; row < getRowCount(); row++) {
                if (isAvailable(row)) {
                    out.writeDouble(((Double) objects[row]).doubleValue());
                }
            }
        } else if (cl == Float.class) {
            for (int row = 0; row < getRowCount(); row++) {
                if (isAvailable(row)) {
                    out.writeFloat(((Float) objects[row]).floatValue());
                }
            }
        } else if (cl == Long.class) {
            for (int row = 0; row < getRowCount(); row++) {
                if (isAvailable(row)) {
                    out.writeLong(((Long) objects[row]).longValue());
                }
            }
        } else if (cl == Integer.class) {
            for (int row = 0; row < getRowCount(); row++) {
                if (isAvailable(row)) {
                    out.writeInt(((Integer) objects[row]).intValue());
                }
            }
        } else if (cl == Short.class) {
            for (int row = 0; row < getRowCount(); row++) {
                if (isAvailable(row)) {
                    out.writeShort(((Short) objects[row]).shortValue());
                }
            }
        } else if (cl == Byte.class) {
            for (int row = 0; row < getRowCount(); row++) {
                if (isAvailable(row)) {
                    out.writeByte(((Byte) objects[row]).byteValue());
                }
            }
        } else if (cl == Boolean.class) {
            for (int row = 0; row < getRowCount(); row++) {
                if (isAvailable(row)) {
                    out.writeBoolean(((Boolean) objects[row]).booleanValue());
                }
            }
        } else {
            for (int row = 0; row < getRowCount(); row++) {
                if (isAvailable(row)) {
                    out.writeObject(objects[row]);
                }
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        final int version = in.readInt();
        if (version > 0) {
            final int rowCount = in.readInt();
            this.name = in.readObject();
            this.membership = (Class) in.readObject();
            this.isEditable = in.readBoolean();
            this.objects = new Object[rowCount];
            boolean[] isAvailable = new boolean[rowCount];
            for (int row = 0; row < getRowCount(); row++) {
                isAvailable[row] = in.readBoolean();
            }
            final Class cl = getMembership();
            if (cl == Double.class) {
                for (int row = 0; row < getRowCount(); row++) {
                    if (isAvailable[row]) {
                        objects[row] = Double.valueOf(in.readDouble());
                    } else {
                        objects[row] = null;
                    }
                }
            } else if (cl == Float.class) {
                for (int row = 0; row < getRowCount(); row++) {
                    if (isAvailable[row]) {
                        objects[row] = Float.valueOf(in.readFloat());
                    } else {
                        objects[row] = null;
                    }
                }
            } else if (cl == Long.class) {
                for (int row = 0; row < getRowCount(); row++) {
                    if (isAvailable[row]) {
                        objects[row] = Long.valueOf(in.readLong());
                    } else {
                        objects[row] = null;
                    }
                }
            } else if (cl == Integer.class) {
                for (int row = 0; row < getRowCount(); row++) {
                    if (isAvailable[row]) {
                        objects[row] = Integer.valueOf(in.readInt());
                    } else {
                        objects[row] = null;
                    }
                }
            } else if (cl == Short.class) {
                for (int row = 0; row < getRowCount(); row++) {
                    if (isAvailable[row]) {
                        objects[row] = Short.valueOf(in.readShort());
                    } else {
                        objects[row] = null;
                    }
                }
            } else if (cl == Byte.class) {
                for (int row = 0; row < getRowCount(); row++) {
                    if (isAvailable[row]) {
                        objects[row] = Byte.valueOf(in.readByte());
                    } else {
                        objects[row] = null;
                    }
                }
            } else if (cl == Boolean.class) {
                for (int row = 0; row < getRowCount(); row++) {
                    if (isAvailable[row]) {
                        objects[row] = Boolean.valueOf(in.readBoolean());
                    } else {
                        objects[row] = null;
                    }
                }
            } else {
                for (int row = 0; row < getRowCount(); row++) {
                    if (isAvailable[row]) {
                        objects[row] = in.readObject();
                    } else {
                        objects[row] = null;
                    }
                }
            }
        }
    }

    private Object[] objects;
    private Class membership;
    private Object name;
    private boolean isEditable;
}
