package com.macrofocus.data.matrix.vector;

import com.macrofocus.data.column.AbstractColumnModel;

public abstract class AbstractVectorModel extends AbstractColumnModel implements VectorModel {
    @Override
    public boolean isAvailable(final int index) {
        return !(Double.isNaN(getDouble(index)));
    }

    @Override
    public abstract double getDouble(int index);

    @Override
    public Class getMembership() {
        return Double.class;
    }

    @Override
    public Object getObject(final int index) {
        return Double.valueOf(getDouble(index));
    }

    public String toString() {
        String str = this.getClass().getName() + "[";
        for (int i = 0; i < getRowCount(); i++) {
            if (isAvailable(i)) {
                str = str + getDouble(i);
            } else {
                str = str + "NaN";
            }
            if (i < getRowCount() - 1) {
                str = str + ", ";
            }
        }
        return str + "]";
    }
}
