/*
 * Copyright (c) 2001-2002 Macrofocus GmbH. All Rights Reserved.
 *
 * User: luc
 * Date: Aug 19, 2002
 * Time: 10:28:43 PM
 */
package com.macrofocus.data.matrix.vector.integer;

import com.macrofocus.data.matrix.vector.AbstractVectorModel;

public abstract class AbstractIntegerVectorModel extends AbstractVectorModel implements IntegerVectorModel {
    @Override
    public double getDouble(int row) {
        return (double) getInteger(row);
    }

    @Override
    public abstract boolean isAvailable(int index);

    @Override
    public Object getObject(int index) {
        return Integer.valueOf(getInteger(index));
    }

    @Override
    public Class getMembership() {
        return Integer.class;
    }

    public String toString() {
        String str = this.getClass() + "[";
        for (int i = 0; i < getRowCount(); i++) {
            if (isAvailable(i)) {
                str = str + getInteger(i);
            } else {
                str = str + "NaN";
            }
            if (i < getRowCount() - 1) {
                str = str + ", ";
            }
        }
        return str + "]";
    }
}
