/*
 * Copyright (c) 2001-2002 Macrofocus GmbH. All Rights Reserved.
 *
 * User: luc
 * Date: Aug 19, 2002
 * Time: 10:24:23 PM
 */
package com.macrofocus.data.matrix.vector.integer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SimpleIntegerVectorModel extends AbstractIntegerVectorModel implements Externalizable {
    static final long serialVersionUID = 3137927581748715783L;

    public SimpleIntegerVectorModel() {
        this.areAvailable = new boolean[0];
        this.values = new int[0];
        this.name = null;
    }

    public SimpleIntegerVectorModel(int[] values) {
        this.values = values;
        this.areAvailable = new boolean[values.length];
        for (int i = 0; i < values.length; i++) {
            this.areAvailable[i] = true;
        }
    }

    public SimpleIntegerVectorModel(Object name, int[] values) {
        this.name = name;
        this.values = values;
        this.areAvailable = new boolean[values.length];
        for (int i = 0; i < values.length; i++) {
            this.areAvailable[i] = true;
        }
    }

    public SimpleIntegerVectorModel(boolean[] areAvailable, int[] values, Object name) {
        this.areAvailable = areAvailable;
        this.values = values;
        this.name = name;
    }


    public SimpleIntegerVectorModel(final String value) {
        java.util.StringTokenizer st = new java.util.StringTokenizer(value, ",");

        int count = st.countTokens();

        areAvailable = new boolean[count];
        values = new int[count];

        for (int index = 0; index < count; index++) {
            try {
                values[index] = (Integer.valueOf(st.nextToken().trim())).intValue();
                areAvailable[index] = true;
            } catch (NumberFormatException e) {
                areAvailable[index] = false;
            }
        }
    }

    @Override
    public int getInteger(int row) {
        return values[row];
    }

    @Override
    public boolean isAvailable(int index) {
        return areAvailable[index];
    }

    @Override
    public int getRowCount() {
        return values.length;
    }

    @Override
    public Object getName() {
        return name;
    }


    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeObject(name);
        out.writeInt(values.length);
        for (int i = 0; i < getRowCount(); i++) {
            out.writeBoolean(isAvailable(i));
        }
        for (int i = 0; i < getRowCount(); i++) {
            if (isAvailable(i)) {
                out.writeInt(getInteger(i));
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            this.name = in.readObject();
            int size = in.readInt();
            areAvailable = new boolean[size];
            values = new int[size];
            for (int i = 0; i < getRowCount(); i++) {
                areAvailable[i] = in.readBoolean();
            }
            for (int i = 0; i < getRowCount(); i++) {
                if (isAvailable(i)) {
                    values[i] = in.readInt();
                }
            }
        }
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < getRowCount(); i++) {
            if (isAvailable(i)) {
                str = str + getInteger(i);
            } else {
                str = str + "NaN";
            }
            if (i < getRowCount() - 1) {
                str = str + ",";
            }
        }
        return str;
    }

    private boolean[] areAvailable;
    private int[] values;
    private Object name;
}
