package com.macrofocus.data.row;

import com.macrofocus.data.DataModel;

public class DataModelRowModel extends AbstractRowModel {
    public DataModelRowModel(final DataModel dataModel, final int row) {
        this.dataModel = dataModel;
        this.row = row;
    }

    @Override
    public boolean isAvailable(final int column) {
        return dataModel.isAvailable(row, column);
    }

    @Override
    public Object getObject(final int column) {
        return dataModel.getValueAt(row, column);
    }

    @Override
    public Class getMembership(final int column) {
        return dataModel.getColumnClass(column);
    }

    @Override
    public Object getName(final int column) {
        return dataModel.getColumnName(column);
    }

    @Override
    public int getColumnCount() {
        return dataModel.getColumnCount();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DataModelRowModel)) return false;

        final DataModelRowModel dataModelRowModel = (DataModelRowModel) o;

        if (row != dataModelRowModel.row) return false;
        return dataModel != null ? dataModel.equals(dataModelRowModel.dataModel) : dataModelRowModel.dataModel == null;
    }

    public int hashCode() {
        int result;
        result = row;
        result = 29 * result + (dataModel != null ? dataModel.hashCode() : 0);
        return result;
    }

    private final int row;
    private final DataModel dataModel;
}
