/*
 * Copyright (c) 2009 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.resources.properties;

public class PropertiesEvent {
    public PropertiesEvent(final PropertiesModel propertiesModel) {
        this(propertiesModel, null, null, null);
    }

    public PropertiesEvent(final PropertiesModel propertiesModel, String key, Object value, Object previousValue) {
        this.propertiesModel = propertiesModel;
        this.key = key;
        this.value = value;
        this.previousValue = previousValue;
    }

    public PropertiesModel getPropertiesModel() {
        return propertiesModel;
    }

    public boolean isKeyModified(String key) {
        return this.key == null || this.key.equals(key);
    }

    public String getKey() {
        return key;
    }

    public Object getValue() {
        return value;
    }

    public Object getPreviousValue() {
        return previousValue;
    }

    private final PropertiesModel propertiesModel;
    private final String key;
    private final Object value;
    private final Object previousValue;
}
