/*
 * Copyright (c) 2009 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.resources.properties;

import com.macrofocus.common.properties.MutableProperty;

import java.awt.*;
import java.util.Hashtable;
import java.util.Map;

/**
 * Responsible for holding key value pair properties information.
 *
 */
public interface PropertiesModel {
    /**
     * Test if the value for a particular key exists.
     *
     * @param key a <code>String</code> value
     * @return an <code>Object</code> value
     */
    boolean isAvailable(String key);

    /**
     * Returns the value for a particular key.
     *
     * @param key a <code>String</code> value
     * @return an <code>Object</code> value
     */
    Object getValue(String key);

    /**
     * Returns the color for a particular key.
     *
     * @param key a <code>String</code> value
     * @return a <code>Color</code> value
     */
    Color getColor(String key);

    <T> MutableProperty<T> getProperty(String key);

    /**
     * Add a <code>PropertiesListener</code> to be notified in case of updates.
     *
     * @param propertiesListener a <code>PropertiesListener</code> value
     */
    void addPropertiesListener(PropertiesListener propertiesListener);

    void addWeakPropertiesListener(PropertiesListener listener);

    /**
     * Add a <code>PropertiesListener</code> to be notified in case of updates.
     *
     * @param propertiesListener a <code>PropertiesListener</code> value
     */
    void removePropertiesListener(PropertiesListener propertiesListener);

    /**
     * Reload the properties.
     */
    void reload();

    void setValue(Class cl, String name, String property, Object value);

    void setValue(String name, Object value);

    void setValues(PropertiesModel propertiesModel);

    Map getMap();

    void resetValues(PropertiesModel propertiesModel);

    Object getValue(String key, Object defaultValue);

    void setValues(Hashtable hashtable);

    /**
     * Test if the value for a key composed of the class, instance name, and property name exists.
     *
     * @param cl       a <code>Class</code> value
     * @param name     a <code>String</code> value
     * @param property a <code>String</code> value
     * @return an <code>Object</code> value
     * @deprecated
     */
    boolean isAvailable(Class cl, String name, String property);

    /**
     * Returns the value for a key composed of the class, instance name, and property name.
     *
     * @param cl       a <code>Class</code> value
     * @param name     a <code>String</code> value
     * @param property a <code>String</code> value
     * @return an <code>Object</code> value
     * @deprecated
     */
    Object getValue(Class cl, String name, String property);

    /**
     * Returns the value for a key composed of the class, instance name, and property name, or the
     * specidifed default value.
     *
     * @param cl       a <code>Class</code> value
     * @param name     a <code>String</code> value
     * @param property a <code>String</code> value
     * @param defaultValue an <code>Object</code> value
     * @return an <code>Object</code> value
     * @deprecated
     */
    Object getValue(Class cl, String name, String property, Object defaultValue);

    /**
     * Returns the value for a key composed of the class and the property name.
     *
     * @param cl       a <code>Class</code> value
     * @param property a <code>String</code> value
     * @return an <code>Object</code> value
     * @deprecated
     */
    Object getValue(Class cl, String property);

    /**
     * Returns the value for a key composed of the class, and property name, or the
     * specidifed default value.
     *
     * @param cl       a <code>Class</code> value
     * @param property a <code>String</code> value
     * @param defaultValue an <code>Object</code> value
     * @return an <code>Object</code> value
     * @deprecated
     */
    Object getValue(Class cl, String property, Object defaultValue);

    /**
     * Set the value for a key composed of the class, instance name, and property name.
     *
     * @param cl    a <code>Class</code> value
     * @param name  a <code>String</code> value
     * @param value a <code>Object</code> value
     * @deprecated
     */
    void setValue(Class cl, String name, Object value);
}
