package org.molap.json

import kotlinx.io.Sink
import kotlinx.io.asOutputStream
import org.molap.dataframe.DataFrame
import org.molap.exporter.FileDataFrameExporter
import java.io.File
import java.io.OutputStream

fun <R,C,V> DataFrame<R, C, V>.writeJson(sink: Sink) {
    val outputStream = sink.asOutputStream()
    writeJson(outputStream)
    sink.flush()
}

fun <R,C,V> DataFrame<R, C, V>.writeJson(file: File) {
    val outputStream = file.outputStream()
    writeJson(outputStream)
    outputStream.flush()
    outputStream.close()
}

fun <R,C,V> DataFrame<R, C, V>.writeJson(outputStream: OutputStream) {
    FileDataFrameExporter.exportJSon(this, outputStream)
}