/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.cuboid;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.cube.Cube;
import org.molap.aggregates.cube.Dice;
import org.molap.aggregates.cube.Dimensions;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cube.GroupFactory;
import org.molap.aggregates.cube.InMemoryCube;
import org.molap.aggregates.cuboid.AbstractCuboid;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.aggregates.query.Structure;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170\u001b\"\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0016J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00192\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0019H\u0016J\u001a\u0010$\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010%2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010&\u001a\u00020'2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170%2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001e\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lorg/molap/aggregates/cuboid/ApexCuboid;", "Lorg/molap/aggregates/cuboid/AbstractCuboid;", "cube", "Lorg/molap/aggregates/cube/InMemoryCube;", "dimensions", "Lorg/molap/aggregates/cube/Dimensions;", "<init>", "(Lorg/molap/aggregates/cube/InMemoryCube;Lorg/molap/aggregates/cube/Dimensions;)V", "Lorg/molap/aggregates/cube/Cube;", "getCube", "()Lorg/molap/aggregates/cube/Cube;", "getDimensions", "()Lorg/molap/aggregates/cube/Dimensions;", "group", "Lorg/molap/aggregates/cube/Group;", "getGroup", "()Lorg/molap/aggregates/cube/Group;", "groups", "", "getGroups", "()Ljava/util/List;", "listener", "Lorg/molap/dataframe/DataFrameListener;", "", "drillDown", "Lorg/molap/aggregates/cuboid/Cuboid;", "columns", "", "([Ljava/lang/Object;)Lorg/molap/aggregates/cuboid/Cuboid;", "drillUp", "slice", "values", "dice", "valuesSets", "", "collapse", "getGroupsStartingWith", "", "getGroupsStartingWithCount", "", "groupsCount", "getGroupsCount", "()I", "getValues", "()Ljava/util/Set;", "getRows", "molap"})
public final class ApexCuboid
extends AbstractCuboid {
    @NotNull
    private final Cube cube;
    @NotNull
    private final Dimensions dimensions;
    @NotNull
    private final Group group;
    @NotNull
    private final List<Group> groups;
    @NotNull
    private final DataFrameListener<Object, Object> listener;
    @Nullable
    private final Set<Object> values;

    public ApexCuboid(@NotNull InMemoryCube cube, @NotNull Dimensions dimensions) {
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        super(cube);
        this.cube = cube;
        this.group = GroupFactory.INSTANCE.createRoot();
        this.groups = CollectionsKt.listOf((Object)this.group);
        this.listener = new DataFrameListener<Object, Object>(this){
            final /* synthetic */ ApexCuboid this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataFrameChanged(DataFrameEvent<Object, Object> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.setDirty(true);
            }
        };
        this.values = SetsKt.emptySet();
        this.dimensions = dimensions;
        cube.getDataFrame().addWeakDataFrameListener(this.listener);
    }

    @Override
    @NotNull
    public Cube getCube() {
        return this.cube;
    }

    @Override
    @NotNull
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    @NotNull
    public final Group getGroup() {
        return this.group;
    }

    @NotNull
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    @NotNull
    public Cuboid drillDown(Object ... columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        Dimensions dimensions = this.getCube().getRoot();
        Intrinsics.checkNotNull((Object)dimensions);
        Dimensions dimensions2 = dimensions.drillDown(Arrays.copyOf(columns, columns.length));
        Set[] diceValues = new Set[columns.length];
        int n = 0;
        int n2 = columns.length;
        boolean[] blArray = new boolean[n2];
        while (n < n2) {
            int n3 = n++;
            blArray[n3] = false;
        }
        boolean[] structureValues = blArray;
        Cube cube = this.getCube();
        Dimensions dimensions3 = dimensions2;
        Intrinsics.checkNotNull((Object)dimensions3);
        Dice dice = this.getCube().getDice();
        Intrinsics.checkNotNull((Object)dice);
        Dice dice2 = dice.drillDownByArray(diceValues);
        Structure structure = this.getCube().getStructure();
        Intrinsics.checkNotNull((Object)structure);
        Cuboid cuboid = cube.getCuboid(dimensions3, dice2, structure.drillDown(Arrays.copyOf(structureValues, structureValues.length)));
        Intrinsics.checkNotNull((Object)cuboid);
        return cuboid;
    }

    @Override
    @Nullable
    public Cuboid drillUp() {
        return null;
    }

    @Override
    @Nullable
    public Cuboid slice(@Nullable Object values) {
        return null;
    }

    @Override
    @Nullable
    public Cuboid dice(@NotNull Set<? extends Object> valuesSets) {
        Intrinsics.checkNotNullParameter(valuesSets, (String)"valuesSets");
        return null;
    }

    @Override
    @Nullable
    public Cuboid collapse() {
        return null;
    }

    @Override
    @Nullable
    public Iterable<Group> getGroupsStartingWith(@Nullable Group group) {
        return null;
    }

    @Override
    public int getGroupsStartingWithCount(@Nullable Group group) {
        return 0;
    }

    @Override
    public int getGroupsCount() {
        return this.getGroups().size();
    }

    @Override
    @Nullable
    public Set<Object> getValues() {
        return this.values;
    }

    @Override
    @NotNull
    public Iterable<Object> getRows(@Nullable Group group) {
        return this.getCube().getDataFrame().rows();
    }
}

