/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.Aggregation;
import org.molap.aggregates.cube.Cube;
import org.molap.aggregates.cube.Dimensions;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.aggregates.query.AbstractQuery;
import org.molap.aggregates.query.Query;
import org.molap.aggregates.query.QueryListener;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0006123456B7\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\"\u0010\u0004\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0005\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tBA\b\u0016\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\"\u0010\u0004\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0005\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\u000eJ\b\u0010%\u001a\u00020&H\u0002J$\u0010'\u001a\u0004\u0018\u00010\u00072\b\u0010(\u001a\u0004\u0018\u00010\u00182\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0016J\u0018\u0010.\u001a\u00020&2\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000700H\u0016R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00178VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R!\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00067"}, d2={"Lorg/molap/aggregates/query/CuboidQuery;", "Lorg/molap/aggregates/query/AbstractQuery;", "cuboid", "Lorg/molap/aggregates/cuboid/Cuboid;", "aggregations", "", "Lorg/molap/aggregates/aggregation/Aggregation;", "", "<init>", "(Lorg/molap/aggregates/cuboid/Cuboid;[Lorg/molap/aggregates/aggregation/Aggregation;)V", "query", "Lorg/molap/aggregates/query/Query;", "operation", "Lorg/molap/aggregates/query/CuboidQuery$Operation;", "(Lorg/molap/aggregates/query/Query;Lorg/molap/aggregates/query/CuboidQuery$Operation;[Lorg/molap/aggregates/aggregation/Aggregation;)V", "getCuboid", "()Lorg/molap/aggregates/cuboid/Cuboid;", "setCuboid", "(Lorg/molap/aggregates/cuboid/Cuboid;)V", "getAggregations", "()[Lorg/molap/aggregates/aggregation/Aggregation;", "[Lorg/molap/aggregates/aggregation/Aggregation;", "groups", "", "Lorg/molap/aggregates/cube/Group;", "getGroups", "()Ljava/util/List;", "setGroups", "(Ljava/util/List;)V", "queryListener", "Lorg/molap/aggregates/query/QueryListener;", "getQueryListener", "()Lorg/molap/aggregates/query/QueryListener;", "dataFrameListener", "Lorg/molap/dataframe/DataFrameListener;", "getDataFrameListener", "()Lorg/molap/dataframe/DataFrameListener;", "run", "", "getValue", "path", "aggregation", "dimensions", "Lorg/molap/aggregates/cube/Dimensions;", "getDimensions", "()Lorg/molap/aggregates/cube/Dimensions;", "setDice", "valuesSets", "", "Operation", "DrillDownOperation", "DrillUpOperation", "SliceOperation", "DiceOperation", "CollapseOperation", "molap"})
public final class CuboidQuery
extends AbstractQuery {
    @Nullable
    private Cuboid cuboid;
    @Nullable
    private Query query;
    @Nullable
    private Operation operation;
    @NotNull
    private final Aggregation<Object>[] aggregations;
    @Nullable
    private List<? extends Group> groups;
    @NotNull
    private final QueryListener queryListener;
    @NotNull
    private final DataFrameListener<Object, Object> dataFrameListener;

    @Override
    @Nullable
    public Cuboid getCuboid() {
        if (this.cuboid == null) {
            Operation operation = this.operation;
            Intrinsics.checkNotNull((Object)operation);
            Query query = this.query;
            Intrinsics.checkNotNull((Object)query);
            this.cuboid = operation.get(query.getCuboid());
        }
        return this.cuboid;
    }

    public void setCuboid(@Nullable Cuboid cuboid) {
        this.cuboid = cuboid;
    }

    @Override
    @NotNull
    public Aggregation<Object>[] getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public List<Group> getGroups() {
        if (this.isDirty()) {
            this.run();
        }
        return this.groups;
    }

    public void setGroups(@Nullable List<? extends Group> list) {
        this.groups = list;
    }

    @NotNull
    public final QueryListener getQueryListener() {
        return this.queryListener;
    }

    @NotNull
    public final DataFrameListener<Object, Object> getDataFrameListener() {
        return this.dataFrameListener;
    }

    public CuboidQuery(@Nullable Cuboid cuboid, Aggregation<Object> ... aggregations) {
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        this.queryListener = new QueryListener(this){
            final /* synthetic */ CuboidQuery this$0;
            {
                this.this$0 = $receiver;
            }

            public void queryChanged() {
                this.this$0.setCuboid(null);
                this.this$0.setDirty(true);
                this.this$0.notifyQueryChanged();
            }
        };
        this.dataFrameListener = new DataFrameListener<Object, Object>(this){
            final /* synthetic */ CuboidQuery this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataFrameChanged(DataFrameEvent<Object, Object> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.setDirty(true);
                this.this$0.notifyQueryChanged();
            }
        };
        this.setCuboid(cuboid);
        this.aggregations = aggregations;
        Cuboid cuboid2 = this.getCuboid();
        Intrinsics.checkNotNull((Object)cuboid2);
        Cube cube = cuboid2.getCube();
        Intrinsics.checkNotNull((Object)cube);
        cube.getDataFrame().addWeakDataFrameListener(this.dataFrameListener);
    }

    public CuboidQuery(@Nullable Query query, @Nullable Operation operation, Aggregation<Object> ... aggregations) {
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        this.queryListener = new /* invalid duplicate definition of identical inner class */;
        this.dataFrameListener = new /* invalid duplicate definition of identical inner class */;
        this.query = query;
        this.operation = operation;
        this.aggregations = aggregations;
        Query query2 = this.query;
        Intrinsics.checkNotNull((Object)query2);
        query2.addWeakQueryListener(this.queryListener);
    }

    private final void run() {
        this.setDirty(false);
        List groups = new ArrayList();
        Cuboid cuboid = this.getCuboid();
        Intrinsics.checkNotNull((Object)cuboid);
        Iterable<Group> iterable = cuboid.getGroups();
        Intrinsics.checkNotNull(iterable);
        for (Group group : iterable) {
            groups.add(group);
        }
        this.setGroups(groups);
    }

    @Override
    @Nullable
    public Object getValue(@Nullable Group path, @NotNull Aggregation<Object> aggregation) {
        Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
        return aggregation.compute(this.getCuboid(), path);
    }

    @Override
    @NotNull
    public Dimensions getDimensions() {
        Cuboid cuboid = this.getCuboid();
        Intrinsics.checkNotNull((Object)cuboid);
        Dimensions dimensions = cuboid.getDimensions();
        Intrinsics.checkNotNull((Object)dimensions);
        return dimensions;
    }

    @Override
    public void setDice(@NotNull Set<? extends Object> valuesSets) {
        Intrinsics.checkNotNullParameter(valuesSets, (String)"valuesSets");
        this.operation = new DiceOperation(valuesSets);
        this.setCuboid(null);
        this.setDirty(true);
        this.notifyQueryChanged();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0096\u0002\u00a8\u0006\u0007"}, d2={"Lorg/molap/aggregates/query/CuboidQuery$CollapseOperation;", "Lorg/molap/aggregates/query/CuboidQuery$Operation;", "<init>", "()V", "get", "Lorg/molap/aggregates/cuboid/Cuboid;", "cuboid", "molap"})
    public static final class CollapseOperation
    implements Operation {
        @Override
        @Nullable
        public Cuboid get(@Nullable Cuboid cuboid) {
            Cuboid cuboid2 = cuboid;
            Intrinsics.checkNotNull((Object)cuboid2);
            return cuboid2.collapse();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0096\u0002R\u0018\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/molap/aggregates/query/CuboidQuery$DiceOperation;", "Lorg/molap/aggregates/query/CuboidQuery$Operation;", "dice", "", "", "<init>", "(Ljava/util/Set;)V", "get", "Lorg/molap/aggregates/cuboid/Cuboid;", "cuboid", "molap"})
    public static final class DiceOperation
    implements Operation {
        @Nullable
        private final Set<Object> dice;

        public DiceOperation(@Nullable Set<? extends Object> dice) {
            this.dice = dice;
        }

        @Override
        @Nullable
        public Cuboid get(@Nullable Cuboid cuboid) {
            Cuboid cuboid2 = cuboid;
            Intrinsics.checkNotNull((Object)cuboid2);
            Set<Object> set = this.dice;
            Intrinsics.checkNotNull(set);
            return cuboid2.dice(set);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0003\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0096\u0002R\u001a\u0010\u0002\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/molap/aggregates/query/CuboidQuery$DrillDownOperation;", "Lorg/molap/aggregates/query/CuboidQuery$Operation;", "columns", "", "", "<init>", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "get", "Lorg/molap/aggregates/cuboid/Cuboid;", "cuboid", "molap"})
    public static final class DrillDownOperation
    implements Operation {
        @NotNull
        private final Object[] columns;

        public DrillDownOperation(Object ... columns) {
            Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
            this.columns = columns;
        }

        @Override
        @Nullable
        public Cuboid get(@Nullable Cuboid cuboid) {
            for (Object object : this.columns) {
            }
            Cuboid cuboid2 = cuboid;
            Intrinsics.checkNotNull((Object)cuboid2);
            Object[] objectArray = this.columns;
            return cuboid2.drillDown(Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0096\u0002\u00a8\u0006\u0007"}, d2={"Lorg/molap/aggregates/query/CuboidQuery$DrillUpOperation;", "Lorg/molap/aggregates/query/CuboidQuery$Operation;", "<init>", "()V", "get", "Lorg/molap/aggregates/cuboid/Cuboid;", "cuboid", "molap"})
    public static final class DrillUpOperation
    implements Operation {
        @Override
        @Nullable
        public Cuboid get(@Nullable Cuboid cuboid) {
            Cuboid cuboid2 = cuboid;
            Intrinsics.checkNotNull((Object)cuboid2);
            return cuboid2.drillUp();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00a6\u0002\u00a8\u0006\u0005\u00c0\u0006\u0003"}, d2={"Lorg/molap/aggregates/query/CuboidQuery$Operation;", "", "get", "Lorg/molap/aggregates/cuboid/Cuboid;", "cuboid", "molap"})
    public static interface Operation {
        @Nullable
        public Cuboid get(@Nullable Cuboid var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0096\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/query/CuboidQuery$SliceOperation;", "Lorg/molap/aggregates/query/CuboidQuery$Operation;", "slice", "", "<init>", "(Ljava/lang/Object;)V", "get", "Lorg/molap/aggregates/cuboid/Cuboid;", "cuboid", "molap"})
    public static final class SliceOperation
    implements Operation {
        @Nullable
        private final Object slice;

        public SliceOperation(@Nullable Object slice) {
            this.slice = slice;
        }

        @Override
        @Nullable
        public Cuboid get(@Nullable Cuboid cuboid) {
            Cuboid cuboid2 = cuboid;
            Intrinsics.checkNotNull((Object)cuboid2);
            return cuboid2.slice(this.slice);
        }
    }
}

