/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.query;

import com.macrofocus.common.collection.Collections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.Aggregation;
import org.molap.aggregates.cube.ArrayGroup;
import org.molap.aggregates.cube.Dimensions;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.aggregates.query.AbstractQuery;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B=\u0012\u0010\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u0012\"\u0010\u0005\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0003\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0016J\u0018\u0010#\u001a\u00020\u001c2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070%H\u0016R\u001a\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR$\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0016\u0010 \u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lorg/molap/aggregates/query/CuboidsQuery;", "Lorg/molap/aggregates/query/AbstractQuery;", "cuboids", "", "Lorg/molap/aggregates/cuboid/Cuboid;", "aggregations", "Lorg/molap/aggregates/aggregation/Aggregation;", "", "<init>", "([Lorg/molap/aggregates/cuboid/Cuboid;[Lorg/molap/aggregates/aggregation/Aggregation;)V", "[Lorg/molap/aggregates/cuboid/Cuboid;", "getAggregations", "()[Lorg/molap/aggregates/aggregation/Aggregation;", "[Lorg/molap/aggregates/aggregation/Aggregation;", "groups", "", "Lorg/molap/aggregates/cube/Group;", "getGroups", "()Ljava/util/List;", "setGroups", "(Ljava/util/List;)V", "dimensions", "Lorg/molap/aggregates/cube/Dimensions;", "getDimensions", "()Lorg/molap/aggregates/cube/Dimensions;", "setDimensions", "(Lorg/molap/aggregates/cube/Dimensions;)V", "run", "", "getValue", "path", "aggregation", "cuboid", "getCuboid", "()Lorg/molap/aggregates/cuboid/Cuboid;", "setDice", "valuesSets", "", "CuboidGroup", "molap"})
@SourceDebugExtension(value={"SMAP\nCuboidsQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CuboidsQuery.kt\norg/molap/aggregates/query/CuboidsQuery\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,99:1\n37#2,2:100\n*S KotlinDebug\n*F\n+ 1 CuboidsQuery.kt\norg/molap/aggregates/query/CuboidsQuery\n*L\n38#1:100,2\n*E\n"})
public final class CuboidsQuery
extends AbstractQuery {
    @Nullable
    private final Cuboid[] cuboids;
    @NotNull
    private final Aggregation<Object>[] aggregations;
    @Nullable
    private List<Group> groups;
    @Nullable
    private Dimensions dimensions;

    public CuboidsQuery(@Nullable Cuboid[] cuboids, Aggregation<Object> ... aggregations) {
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        this.cuboids = cuboids;
        this.aggregations = aggregations;
    }

    @Override
    @NotNull
    public Aggregation<Object>[] getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public List<Group> getGroups() {
        if (this.isDirty()) {
            this.run();
        }
        return this.groups;
    }

    public void setGroups(@Nullable List<Group> list) {
        this.groups = list;
    }

    @Override
    @Nullable
    public Dimensions getDimensions() {
        if (this.isDirty()) {
            this.run();
        }
        return this.dimensions;
    }

    public void setDimensions(@Nullable Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    private final void run() {
        this.setDirty(false);
        Set columns = new HashSet();
        Intrinsics.checkNotNull((Object)this.cuboids);
        for (Cuboid cuboid : this.cuboids) {
            Dimensions d = cuboid.getDimensions();
            Collection collection = columns;
            Object[] objectArray = new Object[1];
            Dimensions dimensions = d;
            Intrinsics.checkNotNull((Object)dimensions);
            objectArray[0] = dimensions.getPath();
            Collections.INSTANCE.addAll(collection, objectArray);
        }
        Collection $this$toTypedArray$iv = columns;
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        Object[] objectArray = collection.toArray(new Object[0]);
        this.setDimensions(Dimensions.Companion.create(Arrays.copyOf(objectArray, objectArray.length)));
        this.setGroups(new ArrayList());
        for (Cuboid cuboid : this.cuboids) {
            Iterable<Group> iterable = cuboid.getGroups();
            Intrinsics.checkNotNull(iterable);
            for (Group group : iterable) {
                List<Group> list = this.getGroups();
                Intrinsics.checkNotNull(list);
                list.add(new CuboidGroup(cuboid, this.getDimensions(), group));
            }
        }
    }

    @Override
    @Nullable
    public Object getValue(@Nullable Group path, @NotNull Aggregation<Object> aggregation) {
        Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
        Intrinsics.checkNotNull((Object)path, (String)"null cannot be cast to non-null type org.molap.aggregates.query.CuboidsQuery.CuboidGroup");
        return aggregation.compute(((CuboidGroup)path).getCuboid(), ((CuboidGroup)path).getOriginalGroup());
    }

    @Override
    @Nullable
    public Cuboid getCuboid() {
        return null;
    }

    @Override
    public void setDice(@NotNull Set<? extends Object> valuesSets) {
        Intrinsics.checkNotNullParameter(valuesSets, (String)"valuesSets");
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/molap/aggregates/query/CuboidsQuery$CuboidGroup;", "Lorg/molap/aggregates/cube/ArrayGroup;", "cuboid", "Lorg/molap/aggregates/cuboid/Cuboid;", "dimensions", "Lorg/molap/aggregates/cube/Dimensions;", "group", "Lorg/molap/aggregates/cube/Group;", "<init>", "(Lorg/molap/aggregates/cuboid/Cuboid;Lorg/molap/aggregates/cube/Dimensions;Lorg/molap/aggregates/cube/Group;)V", "getCuboid", "()Lorg/molap/aggregates/cuboid/Cuboid;", "originalGroup", "getOriginalGroup", "()Lorg/molap/aggregates/cube/Group;", "path", "", "", "getPath", "()[Ljava/lang/Object;", "i", "", "molap"})
    private static final class CuboidGroup
    extends ArrayGroup {
        @NotNull
        private final Cuboid cuboid;
        @Nullable
        private final Dimensions dimensions;
        @NotNull
        private final Group group;

        public CuboidGroup(@NotNull Cuboid cuboid, @Nullable Dimensions dimensions, @NotNull Group group) {
            Intrinsics.checkNotNullParameter((Object)cuboid, (String)"cuboid");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Object[] objectArray = new Object[]{group.getPath()};
            super(objectArray);
            this.cuboid = cuboid;
            this.dimensions = dimensions;
            this.group = group;
        }

        @NotNull
        public final Cuboid getCuboid() {
            return this.cuboid;
        }

        @NotNull
        public final Group getOriginalGroup() {
            return this.group;
        }

        @Override
        @NotNull
        public Object[] getPath() {
            Dimensions dimensions = this.dimensions;
            Intrinsics.checkNotNull((Object)dimensions);
            Object[] path = new Object[dimensions.getPath().length];
            int n = this.dimensions.getPath().length;
            for (int i = 0; i < n; ++i) {
                Object column = this.dimensions.getPath()[i];
                Dimensions dimensions2 = this.cuboid.getDimensions();
                Integer index = dimensions2 != null ? dimensions2.getIndex(column) : null;
                path[i] = index != null ? this.group.getPath(index) : Cuboid.Companion.getALL();
            }
            return path;
        }

        @Override
        @Nullable
        public Object getPath(int i) {
            return this.getPath()[i];
        }
    }
}

