/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.query;

import com.macrofocus.common.collection.UniversalComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.Aggregation;
import org.molap.aggregates.cube.Dimensions;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.aggregates.query.AbstractQuery;
import org.molap.aggregates.query.Query;
import org.molap.aggregates.query.QueryListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J$\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0016J\u0018\u0010'\u001a\u00020\u001b2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070)H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0014j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u0004\u0018\u00010$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lorg/molap/aggregates/query/OrderQuery;", "Lorg/molap/aggregates/query/AbstractQuery;", "query", "Lorg/molap/aggregates/query/Query;", "aggregations", "", "Lorg/molap/aggregates/aggregation/Aggregation;", "", "<init>", "(Lorg/molap/aggregates/query/Query;[Lorg/molap/aggregates/aggregation/Aggregation;)V", "getAggregations", "()[Lorg/molap/aggregates/aggregation/Aggregation;", "groups", "", "Lorg/molap/aggregates/cube/Group;", "getGroups", "()Ljava/util/List;", "setGroups", "(Ljava/util/List;)V", "universalComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "queryListener", "Lorg/molap/aggregates/query/QueryListener;", "getQueryListener", "()Lorg/molap/aggregates/query/QueryListener;", "run", "", "getValue", "path", "aggregation", "dimensions", "Lorg/molap/aggregates/cube/Dimensions;", "getDimensions", "()Lorg/molap/aggregates/cube/Dimensions;", "cuboid", "Lorg/molap/aggregates/cuboid/Cuboid;", "getCuboid", "()Lorg/molap/aggregates/cuboid/Cuboid;", "setDice", "valuesSets", "", "molap"})
public final class OrderQuery
extends AbstractQuery {
    @NotNull
    private final Query query;
    @Nullable
    private List<? extends Group> groups;
    @NotNull
    private final Comparator<Object> universalComparator;
    @NotNull
    private final QueryListener queryListener;

    public OrderQuery(@NotNull Query query, @NotNull Aggregation<Object>[] aggregations) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        this.universalComparator = (Comparator)new UniversalComparator();
        this.queryListener = new QueryListener(this){
            final /* synthetic */ OrderQuery this$0;
            {
                this.this$0 = $receiver;
            }

            public void queryChanged() {
                this.this$0.setDirty(true);
                this.this$0.notifyQueryChanged();
            }
        };
        this.query = query;
        query.addWeakQueryListener(this.queryListener);
    }

    @Override
    @NotNull
    public Aggregation<Object>[] getAggregations() {
        return this.query.getAggregations();
    }

    @Nullable
    public List<Group> getGroups() {
        if (this.isDirty()) {
            this.run();
        }
        return this.groups;
    }

    public void setGroups(@Nullable List<? extends Group> list) {
        this.groups = list;
    }

    @NotNull
    public final QueryListener getQueryListener() {
        return this.queryListener;
    }

    private final void run() {
        this.setDirty(false);
        List groups = new ArrayList();
        List<Object> list = this.query.getGroups();
        Intrinsics.checkNotNull(list);
        for (Object group : list) {
            Intrinsics.checkNotNull((Object)group, (String)"null cannot be cast to non-null type org.molap.aggregates.cube.Group");
            groups.add((Group)group);
        }
        CollectionsKt.sortWith((List)groups, (Comparator)new Comparator<Group>(this){
            final /* synthetic */ OrderQuery this$0;
            {
                this.this$0 = $receiver;
            }

            public int compare(Group a, Group b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return this.compare(OrderQuery.access$getQuery$p(this.this$0), a, b);
            }

            public final int compare(Query query, Group o1, Group o2) {
                int y;
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                int length = Math.min(o1.getPathLength(), o2.getPathLength());
                if (length > 1 && o1.drillUp() != o2.drillUp()) {
                    Query query2 = query.drillUp();
                    Group group = o1.drillUp();
                    Intrinsics.checkNotNull((Object)group);
                    Group group2 = o2.drillUp();
                    Intrinsics.checkNotNull((Object)group2);
                    int c = this.compare(query2, group, group2);
                    if (c != 0) {
                        return c;
                    }
                }
                for (Aggregation<Object> aggregation : this.this$0.getAggregations()) {
                    Object v1 = query.getValue(o1, aggregation);
                    Object v2 = query.getValue(o2, aggregation);
                    int compare = OrderQuery.access$getUniversalComparator$p(this.this$0).compare(v1, v2);
                    if (compare == 0) continue;
                    return compare;
                }
                int x = o1.getPathLength();
                return x < (y = o2.getPathLength()) ? -1 : (x == y ? 0 : 1);
            }
        });
        this.setGroups(groups);
    }

    @Override
    @Nullable
    public Object getValue(@Nullable Group path, @NotNull Aggregation<Object> aggregation) {
        Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
        return this.query.getValue(path, aggregation);
    }

    @Override
    @Nullable
    public Dimensions getDimensions() {
        return this.query.getDimensions();
    }

    @Override
    @Nullable
    public Cuboid getCuboid() {
        return this.query.getCuboid();
    }

    @Override
    public void setDice(@NotNull Set<? extends Object> valuesSets) {
        Intrinsics.checkNotNullParameter(valuesSets, (String)"valuesSets");
        this.query.setDice(valuesSets);
    }

    public static final /* synthetic */ Query access$getQuery$p(OrderQuery $this) {
        return $this.query;
    }

    public static final /* synthetic */ Comparator access$getUniversalComparator$p(OrderQuery $this) {
        return $this.universalComparator;
    }
}

