/*
 * Decompiled with CFR 0.152.
 */
package org.molap.convert;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.molap.convert.TypeConverter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0019\u001a\u00020\u00102\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lorg/molap/convert/ToGeometryTypeConverter;", "Lorg/molap/convert/TypeConverter;", "<init>", "()V", "wktTypes", "", "", "getWktTypes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "geometryClasses", "", "Lkotlin/reflect/KClass;", "getGeometryClasses", "()Ljava/util/Set;", "isConvertable", "", "input", "Lorg/molap/convert/TypeConverter$Input;", "convert", "output", "Lorg/molap/convert/TypeConverter$Output;", "type", "getType", "()Lkotlin/reflect/KClass;", "isAssignableFrom", "a", "b", "molap"})
@SourceDebugExtension(value={"SMAP\nToGeometryTypeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToGeometryTypeConverter.kt\norg/molap/convert/ToGeometryTypeConverter\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,129:1\n106#2:130\n78#2,22:131\n106#2:153\n78#2,22:154\n*S KotlinDebug\n*F\n+ 1 ToGeometryTypeConverter.kt\norg/molap/convert/ToGeometryTypeConverter\n*L\n31#1:130\n31#1:131,22\n83#1:153\n83#1:154,22\n*E\n"})
public final class ToGeometryTypeConverter
implements TypeConverter {
    @NotNull
    private final String[] wktTypes;
    @NotNull
    private final Set<KClass<?>> geometryClasses;

    public ToGeometryTypeConverter() {
        Object[] objectArray = new String[]{"POINT", "LINESTRING", "LINEARRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};
        this.wktTypes = objectArray;
        objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Point.class), Reflection.getOrCreateKotlinClass(LineString.class), Reflection.getOrCreateKotlinClass(LinearRing.class), Reflection.getOrCreateKotlinClass(Polygon.class), Reflection.getOrCreateKotlinClass(MultiPoint.class), Reflection.getOrCreateKotlinClass(MultiLineString.class), Reflection.getOrCreateKotlinClass(MultiPolygon.class), Reflection.getOrCreateKotlinClass(GeometryCollection.class)};
        this.geometryClasses = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public final String[] getWktTypes() {
        return this.wktTypes;
    }

    @NotNull
    public final Set<KClass<?>> getGeometryClasses() {
        return this.geometryClasses;
    }

    @Override
    public boolean isConvertable(@NotNull TypeConverter.Input input2) {
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        try {
            if (!this.isAssignableFrom(Reflection.getOrCreateKotlinClass(Geometry.class), input2.getType())) {
                boolean allNull = true;
                int n = input2.size();
                for (int row = 0; row < n; ++row) {
                    Object v = input2.get(row);
                    if (v == null) continue;
                    if (v instanceof String) {
                        String s;
                        String $this$trim$iv = (String)v;
                        boolean $i$f$trim = false;
                        String[] $this$trim$iv$iv = (String[])$this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        if (Intrinsics.areEqual((Object)(s = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (Object)"")) continue;
                        allNull = false;
                        boolean parsed = false;
                        if (StringsKt.startsWith$default((String)s, (String)"SRID", (boolean)false, (int)2, null)) {
                            String string = s.substring(StringsKt.indexOf$default((CharSequence)s, (String)";", (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            s = string;
                        }
                        boolean found = false;
                        for (String type : this.wktTypes) {
                            if (!StringsKt.startsWith$default((String)s, (String)type, (boolean)false, (int)2, null)) continue;
                            found = true;
                        }
                        if (!found) {
                            return false;
                        }
                        try {
                            WKTReader reader = new WKTReader(null, 1, null);
                            reader.read(s);
                            parsed = true;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (parsed) continue;
                        return false;
                    }
                    if (v instanceof Geometry) continue;
                    return false;
                }
                return !allNull;
            }
            return false;
        }
        catch (Error e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @NotNull
    public KClass<?> convert(@NotNull TypeConverter.Input input2, @NotNull TypeConverter.Output output2) {
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        int n = input2.size();
        for (int row = 0; row < n; ++row) {
            Object v = input2.get(row);
            if (v == null) continue;
            if (v instanceof String) {
                String s;
                String $this$trim$iv = (String)v;
                boolean $i$f$trim = false;
                String[] $this$trim$iv$iv = (String[])$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!Intrinsics.areEqual((Object)(s = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (Object)"")) {
                    boolean parsed = false;
                    if (StringsKt.startsWith$default((String)s, (String)"SRID", (boolean)false, (int)2, null)) {
                        String string = s.substring(StringsKt.indexOf$default((CharSequence)s, (String)";", (int)0, (boolean)false, (int)6, null) + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        s = string;
                    }
                    boolean found = false;
                    for (String type : this.wktTypes) {
                        if (!StringsKt.startsWith$default((String)s, (String)type, (boolean)false, (int)2, null)) continue;
                        found = true;
                    }
                    if (!found) {
                        output2.set(row, null);
                    }
                    try {
                        WKTReader reader = new WKTReader(null, 1, null);
                        output2.set(row, reader.read(s));
                        parsed = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (parsed) continue;
                    output2.set(row, null);
                    continue;
                }
                output2.set(row, null);
                continue;
            }
            if (v instanceof Geometry) continue;
            output2.set(row, null);
        }
        return Reflection.getOrCreateKotlinClass(Geometry.class);
    }

    @Override
    @NotNull
    public KClass<?> getType() {
        return Reflection.getOrCreateKotlinClass(Geometry.class);
    }

    public final boolean isAssignableFrom(@NotNull KClass<?> a, @Nullable KClass<?> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        return b != null && (Intrinsics.areEqual(a, b) || this.geometryClasses.contains(b));
    }
}

