/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;
import org.molap.index.UniqueIndex;
import org.molap.series.MutableSeries;
import org.molap.series.Series;
import org.molap.series.SeriesFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003B#\u0012\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0018\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u001d2\u0006\u0010 \u001a\u00020\u0005H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0005H\u0016J \u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u0005H\u0016JA\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00162\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b2\u0006\u0010 \u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010$R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R0\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00160\u0015X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lorg/molap/dataframe/DefaultDataFrame;", "R", "C", "Lorg/molap/dataframe/AbstractDataFrame;", "", "", "", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "<init>", "(Lorg/molap/dataframe/DataFrame;)V", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "setRowIndex", "(Lorg/molap/index/UniqueIndex;)V", "columnIndex", "getColumnIndex", "setColumnIndex", "series", "", "Lorg/molap/series/Series;", "getSeries", "()[Lorg/molap/series/Series;", "setSeries", "([Lorg/molap/series/Series;)V", "[Lorg/molap/series/Series;", "getRowClass", "Lkotlin/reflect/KClass;", "row", "getColumnClass", "column", "getValueAt", "getColumn", "createSeries", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)Lorg/molap/series/Series;", "molap"})
@SourceDebugExtension(value={"SMAP\nDefaultDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDataFrame.kt\norg/molap/dataframe/DefaultDataFrame\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,127:1\n37#2,2:128\n37#2,2:130\n*S KotlinDebug\n*F\n+ 1 DefaultDataFrame.kt\norg/molap/dataframe/DefaultDataFrame\n*L\n39#1:128,2\n41#1:130,2\n*E\n"})
public final class DefaultDataFrame<R, C>
extends AbstractDataFrame<Integer, String, Object> {
    @NotNull
    private UniqueIndex<Integer> rowIndex;
    @NotNull
    private UniqueIndex<String> columnIndex;
    @NotNull
    private Series<Integer, Object>[] series;

    public DefaultDataFrame(@NotNull DataFrame<R, C, Object> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        this.setRowIndex(new IntegerRangeUniqueIndex(0, dataFrame.getRowCount() - 1));
        ArrayList<String> columns = new ArrayList<String>(dataFrame.getColumnCount());
        ArrayList<Series<Integer, Object>> series = new ArrayList<Series<Integer, Object>>(dataFrame.getColumnCount());
        int c = 0;
        for (C column : dataFrame.columns()) {
            C columnKey = dataFrame.getColumnKey(c);
            if (columnKey != null) {
                String toString = columnKey.toString();
                Series<Integer, Object> serie = this.createSeries(dataFrame, column);
                if (serie != null) {
                    columns.add(toString);
                    series.add(serie);
                }
            }
            ++c;
        }
        Collection $this$toTypedArray$iv = columns;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        this.setColumnIndex((UniqueIndex<String>)new DefaultUniqueIndex<String>(Arrays.copyOf(stringArray, stringArray.length)));
        Collection $this$toTypedArray$iv2 = series;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        this.series = thisCollection$iv2.toArray(new Series[0]);
    }

    @Override
    @NotNull
    public UniqueIndex<Integer> getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(@NotNull UniqueIndex<Integer> uniqueIndex) {
        Intrinsics.checkNotNullParameter(uniqueIndex, (String)"<set-?>");
        this.rowIndex = uniqueIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(@NotNull UniqueIndex<String> uniqueIndex) {
        Intrinsics.checkNotNullParameter(uniqueIndex, (String)"<set-?>");
        this.columnIndex = uniqueIndex;
    }

    @NotNull
    public final Series<Integer, Object>[] getSeries() {
        return this.series;
    }

    public final void setSeries(@NotNull Series<Integer, Object>[] seriesArray) {
        Intrinsics.checkNotNullParameter(seriesArray, (String)"<set-?>");
        this.series = seriesArray;
    }

    @Override
    @NotNull
    public KClass<?> getRowClass(int row) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    @NotNull
    public KClass<? extends Object> getColumnClass(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.series[this.getColumnIndex().getAddress(column)].getType();
    }

    @Override
    @Nullable
    public Object getValueAt(int row, @NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.series[this.getColumnIndex().getAddress(column)].get(row);
    }

    @Override
    @Nullable
    public Series<Integer, Object> getColumn(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Series<Integer, Object> serie = this.series[this.getColumnAddress(column)];
        return serie;
    }

    private final Series<Integer, Object> createSeries(DataFrame<R, C, Object> dataFrame, C column) {
        KClass<?> columnClass = dataFrame.getColumnClass(column);
        if (Intrinsics.areEqual(columnClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            int[] values = new int[dataFrame.getRowCount()];
            boolean[] available = new boolean[dataFrame.getRowCount()];
            int n = dataFrame.getRowCount();
            for (int r = 0; r < n; ++r) {
                Integer valueAt = (Integer)dataFrame.getValueAt(dataFrame.getRowKey(r), column);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt;
                    continue;
                }
                available[r] = false;
            }
            Series<Integer, Integer> series = SeriesFactory.Companion.createInteger(values, available);
            Intrinsics.checkNotNull(series, (String)"null cannot be cast to non-null type org.molap.series.MutableSeries<kotlin.Int, kotlin.Any?>");
            return (MutableSeries)series;
        }
        if (Intrinsics.areEqual(columnClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            long[] values = new long[dataFrame.getRowCount()];
            boolean[] available = new boolean[dataFrame.getRowCount()];
            int n = dataFrame.getRowCount();
            for (int r = 0; r < n; ++r) {
                Long valueAt = (Long)dataFrame.getValueAt(dataFrame.getRowKey(r), column);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt;
                    continue;
                }
                available[r] = false;
            }
            Series<Integer, Long> series = SeriesFactory.Companion.createLong(values, available);
            Intrinsics.checkNotNull(series, (String)"null cannot be cast to non-null type org.molap.series.MutableSeries<kotlin.Int, kotlin.Any?>");
            return (MutableSeries)series;
        }
        if (Intrinsics.areEqual(columnClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            float[] values = new float[dataFrame.getRowCount()];
            boolean[] available = new boolean[dataFrame.getRowCount()];
            int n = dataFrame.getRowCount();
            for (int r = 0; r < n; ++r) {
                Float valueAt = (Float)dataFrame.getValueAt(dataFrame.getRowKey(r), column);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt.floatValue();
                    continue;
                }
                available[r] = false;
            }
            Series<Integer, Float> series = SeriesFactory.Companion.createFloat(values, available);
            Intrinsics.checkNotNull(series, (String)"null cannot be cast to non-null type org.molap.series.MutableSeries<kotlin.Int, kotlin.Any?>");
            return (MutableSeries)series;
        }
        if (Intrinsics.areEqual(columnClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            double[] values = new double[dataFrame.getRowCount()];
            boolean[] available = new boolean[dataFrame.getRowCount()];
            int n = dataFrame.getRowCount();
            for (int r = 0; r < n; ++r) {
                Double valueAt = (Double)dataFrame.getValueAt(dataFrame.getRowKey(r), column);
                if (valueAt != null) {
                    available[r] = true;
                    values[r] = valueAt;
                    continue;
                }
                available[r] = false;
            }
            Series<Integer, Object> series = SeriesFactory.Companion.createDouble(values, available);
            Intrinsics.checkNotNull(series, (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
            return series;
        }
        int n = dataFrame.getRowCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            Object valueAt = dataFrame.getValueAt(dataFrame.getRowKey(n2), column);
            objectArray[n2] = valueAt != Cuboid.Companion.getALL() ? valueAt : null;
        }
        Object[] values = objectArray;
        Series<Integer, Object> series = SeriesFactory.Companion.create(values, columnClass);
        Intrinsics.checkNotNull(series, (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
        return series;
    }
}

