/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonFactory;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonValue;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.JsonDataFrameKt;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;
import org.molap.index.UniqueIndex;
import org.molap.series.Series;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001:\u00010B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0014\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0016\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\u0002H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J!\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u0003\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010&J=\u0010'\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010(2\u0010\u0010)\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010$2\u0010\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\f\u00a2\u0006\u0002\u0010+J\u0014\u0010,\u001a\u0004\u0018\u00010\u00042\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0016\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u001d\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00061"}, d2={"Lorg/molap/dataframe/JsonDataFrame;", "Lorg/molap/dataframe/AbstractDataFrame;", "", "", "", "array", "Lcom/macrofocus/common/json/JsonArray;", "<init>", "(Lcom/macrofocus/common/json/JsonArray;)V", "json", "(Ljava/lang/String;)V", "labels", "", "[Ljava/lang/String;", "classes", "Lkotlin/reflect/KClass;", "[Lkotlin/reflect/KClass;", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "rowIndex$delegate", "Lkotlin/Lazy;", "columnIndex", "getColumnIndex", "columnIndex$delegate", "getColumnName", "column", "getColumnClass", "rowCount", "getRowCount", "()I", "getRowClass", "row", "getValueAt", "getRow", "Lorg/molap/series/Series;", "integer", "(Ljava/lang/Integer;)Lorg/molap/series/Series;", "join", "Lorg/molap/dataframe/DataFrame;", "series", "strings", "(Lorg/molap/series/Series;[Ljava/lang/String;)Lorg/molap/dataframe/DataFrame;", "getObject", "value", "Lcom/macrofocus/common/json/JsonValue;", "getClass", "Companion", "molap"})
public final class JsonDataFrame
extends AbstractDataFrame<Integer, String, Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonArray array;
    @NotNull
    private final String[] labels;
    @NotNull
    private final KClass<?>[] classes;
    @NotNull
    private final Lazy rowIndex$delegate;
    @NotNull
    private final Lazy columnIndex$delegate;

    public JsonDataFrame(@NotNull JsonArray array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        HashMap types = new HashMap();
        int n = this.array.length();
        for (int row = 0; row < n; ++row) {
            JsonObject o = (JsonObject)this.array.get(row);
            for (String column : o.keys()) {
                KClass<?> type;
                JsonValue value;
                if (!columns.contains(column)) {
                    columns.add(column);
                    value = o.get(column);
                    type = this.getClass(value);
                    if (type == null) continue;
                    ((Map)types).put(column, type);
                    continue;
                }
                value = o.get(column);
                type = this.getClass(value);
                if (type == null) continue;
                KClass currentType = (KClass)types.get(column);
                if (currentType == null) {
                    ((Map)types).put(column, type);
                    continue;
                }
                if (Intrinsics.areEqual((Object)currentType, type)) continue;
                ((Map)types).put(column, Reflection.getOrCreateKotlinClass(Object.class));
            }
        }
        this.labels = new String[columns.size()];
        this.classes = new KClass[columns.size()];
        int index = 0;
        Iterator iterator2 = columns.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String column;
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            this.labels[index] = column = (String)e;
            KClass type = (KClass)types.get(column);
            KClass kClass = type;
            if (kClass == null) {
                kClass = Reflection.getOrCreateKotlinClass(Object.class);
            }
            this.classes[index] = kClass;
            ++index;
        }
        this.rowIndex$delegate = LazyKt.lazy(() -> JsonDataFrame.rowIndex_delegate$lambda$0(this));
        this.columnIndex$delegate = LazyKt.lazy(() -> JsonDataFrame.columnIndex_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public UniqueIndex<Integer> getRowIndex() {
        Lazy lazy = this.rowIndex$delegate;
        return (UniqueIndex)lazy.getValue();
    }

    @Override
    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        Lazy lazy = this.columnIndex$delegate;
        return (UniqueIndex)lazy.getValue();
    }

    public JsonDataFrame(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonValue jsonValue = JsonFactory.INSTANCE.parse(json);
        Intrinsics.checkNotNull((Object)jsonValue, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonObject");
        JsonValue jsonValue2 = ((JsonObject)jsonValue).get("data");
        Intrinsics.checkNotNull((Object)jsonValue2, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonArray");
        this((JsonArray)jsonValue2);
    }

    @Override
    @Nullable
    public String getColumnName(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.labels[this.getColumnIndex().getAddress(column)];
    }

    @Override
    @NotNull
    public KClass<?> getColumnClass(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        KClass<?> kClass = this.classes[this.getColumnIndex().getAddress(column)];
        Intrinsics.checkNotNull(kClass);
        return kClass;
    }

    @Override
    public int getRowCount() {
        return this.array.length();
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(int row) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    @Nullable
    public Object getValueAt(int row, @NotNull String column) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        JsonObject jsonObject = (JsonObject)this.array.get(row);
        JsonValue jsonValue = jsonObject.get(column);
        if (jsonValue != null && (jsonValue.getType() == JsonType.NULL || jsonValue.getType() == null)) {
            object = null;
        } else if (Intrinsics.areEqual(this.getColumnClass(column), Double.TYPE)) {
            object = jsonObject.getNumber(column);
        } else if (Intrinsics.areEqual(this.getColumnClass(column), Boolean.TYPE)) {
            object = jsonObject.getBoolean(column);
        } else {
            Object object2;
            try {
                object2 = this.getObject(jsonValue);
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).printStackTrace();
                object2 = null;
            }
            object = object2;
        }
        return object;
    }

    @Nullable
    public final Series<String, ?> getRow(@Nullable Integer integer) {
        return null;
    }

    @Nullable
    public final DataFrame<?, ?, ?> join(@Nullable Series<?, ?> series, @Nullable String[] strings) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Object getObject(JsonValue value) {
        Object object;
        if (value != null) {
            if (value.getType() == JsonType.STRING) {
                object = value.asString();
            } else if (value.getType() == JsonType.NUMBER) {
                object = value.asNumber();
            } else if (value.getType() == JsonType.BOOLEAN) {
                object = value.asBoolean();
            } else if (value.getType() == JsonType.ARRAY) {
                void var3_3;
                JsonArray array = (JsonArray)value;
                Object[] a = new Object[array.length()];
                int n = array.length();
                for (int i = 0; i < n; ++i) {
                    a[i] = this.getObject(array.get(i));
                }
                object = var3_3;
            } else {
                object = value.getType() == JsonType.OBJECT ? value.toNative() : (value.getType() == JsonType.NULL ? null : value.toString());
            }
        } else {
            object = null;
        }
        return object;
    }

    private final KClass<?> getClass(JsonValue value) {
        return value.getType() == JsonType.NULL ? null : (value.getType() == JsonType.STRING ? Reflection.getOrCreateKotlinClass(String.class) : (value.getType() == JsonType.NUMBER ? Reflection.getOrCreateKotlinClass(Double.TYPE) : (value.getType() == JsonType.BOOLEAN ? Reflection.getOrCreateKotlinClass(Boolean.TYPE) : (value.getType() == JsonType.ARRAY ? Reflection.getOrCreateKotlinClass(Object[].class) : (value.getType() == JsonType.OBJECT ? Reflection.getOrCreateKotlinClass(JsonObject.class) : Reflection.getOrCreateKotlinClass(String.class))))));
    }

    private static final IntegerRangeUniqueIndex rowIndex_delegate$lambda$0(JsonDataFrame this$0) {
        return new IntegerRangeUniqueIndex(0, this$0.array.length() - 1);
    }

    private static final DefaultUniqueIndex columnIndex_delegate$lambda$0(JsonDataFrame this$0) {
        ArrayList<String> names = new ArrayList<String>(this$0.labels.length);
        for (String string : this$0.labels) {
            Intrinsics.checkNotNull((Object)string);
            names.add(string);
        }
        return new DefaultUniqueIndex((List)names);
    }

    @JvmStatic
    @NotNull
    public static final JsonDataFrame fromInputStream(@NotNull InputStream inputStream) {
        return Companion.fromInputStream(inputStream);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/molap/dataframe/JsonDataFrame$Companion;", "", "<init>", "()V", "fromInputStream", "Lorg/molap/dataframe/JsonDataFrame;", "inputStream", "Ljava/io/InputStream;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "molap"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsonDataFrame fromInputStream(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            byte[] byArray = JsonDataFrameKt.readAllBytes$default(inputStream, 0, 2, null);
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            Charset charset2 = charset;
            String json = new String(byArray, charset2);
            return new JsonDataFrame(json);
        }

        private final Logger getLogger() {
            Logger logger = Logger.getLogger(JsonDataFrame.class.getName());
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

