/*
 * Decompiled with CFR 0.152.
 */
package org.molap.datetime;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlinx.datetime.InstantKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.format.DateTimeComponents;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.DateTimeFormatBuilderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u001a\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/molap/datetime/DateTimeTz;", "", "datetime", "Lkotlin/time/Instant;", "offset", "Lkotlinx/datetime/TimeZone;", "<init>", "(Lkotlin/time/Instant;Lkotlinx/datetime/TimeZone;)V", "getDatetime", "()Lkotlin/time/Instant;", "getOffset", "()Lkotlinx/datetime/TimeZone;", "toISOBasicString", "", "toISOString", "toUTCString", "compareTo", "", "other", "equals", "", "", "hashCode", "component1", "component2", "copy", "toString", "Companion", "molap"})
public final class DateTimeTz
implements Comparable<DateTimeTz> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant datetime;
    @NotNull
    private final TimeZone offset;
    @NotNull
    private static final Lazy<DateTimeFormat<DateTimeComponents>> ISO_TIME_BASIC$delegate = LazyKt.lazy(DateTimeTz::ISO_TIME_BASIC_delegate$lambda$0);
    @NotNull
    private static final Lazy<DateTimeFormat<DateTimeComponents>> isoBasicFormat$delegate = LazyKt.lazy(DateTimeTz::isoBasicFormat_delegate$lambda$0);
    @NotNull
    private static final Lazy<DateTimeFormat<DateTimeComponents>> isoFormat$delegate = LazyKt.lazy(DateTimeTz::isoFormat_delegate$lambda$0);

    public DateTimeTz(@NotNull Instant datetime, @NotNull TimeZone offset) {
        Intrinsics.checkNotNullParameter((Object)datetime, (String)"datetime");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.datetime = datetime;
        this.offset = offset;
    }

    @NotNull
    public final Instant getDatetime() {
        return this.datetime;
    }

    @NotNull
    public final TimeZone getOffset() {
        return this.offset;
    }

    @NotNull
    public final String toISOBasicString() {
        return InstantKt.format((Instant)this.datetime, Companion.getIsoBasicFormat(), (UtcOffset)TimeZoneKt.offsetAt((TimeZone)this.offset, (Instant)this.datetime));
    }

    @NotNull
    public final String toISOString() {
        return InstantKt.format((Instant)this.datetime, Companion.getIsoFormat(), (UtcOffset)TimeZoneKt.offsetAt((TimeZone)this.offset, (Instant)this.datetime));
    }

    @NotNull
    public final String toUTCString() {
        return this.datetime.toString();
    }

    @Override
    public int compareTo(@NotNull DateTimeTz other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.datetime.compareTo(other.datetime);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateTimeTz cfr_ignored_0 = (DateTimeTz)other;
        return Intrinsics.areEqual((Object)this.datetime, (Object)((DateTimeTz)other).datetime);
    }

    public int hashCode() {
        return this.datetime.hashCode();
    }

    @NotNull
    public final Instant component1() {
        return this.datetime;
    }

    @NotNull
    public final TimeZone component2() {
        return this.offset;
    }

    @NotNull
    public final DateTimeTz copy(@NotNull Instant datetime, @NotNull TimeZone offset) {
        Intrinsics.checkNotNullParameter((Object)datetime, (String)"datetime");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return new DateTimeTz(datetime, offset);
    }

    public static /* synthetic */ DateTimeTz copy$default(DateTimeTz dateTimeTz, Instant instant, TimeZone timeZone, int n, Object object) {
        if ((n & 1) != 0) {
            instant = dateTimeTz.datetime;
        }
        if ((n & 2) != 0) {
            timeZone = dateTimeTz.offset;
        }
        return dateTimeTz.copy(instant, timeZone);
    }

    @NotNull
    public String toString() {
        return "DateTimeTz(datetime=" + this.datetime + ", offset=" + this.offset + ")";
    }

    private static final DateTimeFormat ISO_TIME_BASIC_delegate$lambda$0() {
        return DateTimeComponents.Companion.Format(DateTimeTz::ISO_TIME_BASIC_delegate$lambda$0$0);
    }

    private static final Unit ISO_TIME_BASIC_delegate$lambda$0$0(DateTimeFormatBuilder.WithDateTimeComponents $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'T');
        DateTimeFormatBuilder.WithTime.hour$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
        DateTimeFormatBuilder.WithTime.minute$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
        Function1[] function1Array = new Function1[]{DateTimeTz::ISO_TIME_BASIC_delegate$lambda$0$0$0};
        DateTimeFormatBuilderKt.alternativeParsing((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (Function1[])function1Array, DateTimeTz::ISO_TIME_BASIC_delegate$lambda$0$0$1);
        return Unit.INSTANCE;
    }

    private static final Unit ISO_TIME_BASIC_delegate$lambda$0$0$0(DateTimeFormatBuilder.WithDateTimeComponents $this$alternativeParsing) {
        Intrinsics.checkNotNullParameter((Object)$this$alternativeParsing, (String)"$this$alternativeParsing");
        return Unit.INSTANCE;
    }

    private static final Unit ISO_TIME_BASIC_delegate$lambda$0$0$1(DateTimeFormatBuilder.WithDateTimeComponents $this$alternativeParsing) {
        Intrinsics.checkNotNullParameter((Object)$this$alternativeParsing, (String)"$this$alternativeParsing");
        DateTimeFormatBuilder.WithTime.second$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$alternativeParsing), null, (int)1, null);
        DateTimeFormatBuilderKt.optional$default((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$alternativeParsing), null, DateTimeTz::ISO_TIME_BASIC_delegate$lambda$0$0$1$0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit ISO_TIME_BASIC_delegate$lambda$0$0$1$0(DateTimeFormatBuilder.WithDateTimeComponents $this$optional) {
        Intrinsics.checkNotNullParameter((Object)$this$optional, (String)"$this$optional");
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$optional), (char)'.');
        $this$optional.secondFraction(1, 9);
        return Unit.INSTANCE;
    }

    private static final DateTimeFormat isoBasicFormat_delegate$lambda$0() {
        return DateTimeComponents.Companion.Format(DateTimeTz::isoBasicFormat_delegate$lambda$0$0);
    }

    private static final Unit isoBasicFormat_delegate$lambda$0$0(DateTimeFormatBuilder.WithDateTimeComponents $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        $this$Format.date(LocalDate.Formats.INSTANCE.getISO_BASIC());
        $this$Format.dateTimeComponents(Companion.getISO_TIME_BASIC$molap());
        $this$Format.offset(UtcOffset.Formats.INSTANCE.getISO_BASIC());
        return Unit.INSTANCE;
    }

    private static final DateTimeFormat isoFormat_delegate$lambda$0() {
        return DateTimeComponents.Companion.Format(DateTimeTz::isoFormat_delegate$lambda$0$0);
    }

    private static final Unit isoFormat_delegate$lambda$0$0(DateTimeFormatBuilder.WithDateTimeComponents $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        $this$Format.date(LocalDate.Formats.INSTANCE.getISO());
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'T');
        $this$Format.time(LocalTime.Formats.INSTANCE.getISO());
        $this$Format.offset(UtcOffset.Formats.INSTANCE.getISO());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/molap/datetime/DateTimeTz$Companion;", "", "<init>", "()V", "ISO_TIME_BASIC", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/format/DateTimeComponents;", "getISO_TIME_BASIC$molap", "()Lkotlinx/datetime/format/DateTimeFormat;", "ISO_TIME_BASIC$delegate", "Lkotlin/Lazy;", "isoBasicFormat", "getIsoBasicFormat", "isoBasicFormat$delegate", "isoFormat", "getIsoFormat", "isoFormat$delegate", "molap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormat<DateTimeComponents> getISO_TIME_BASIC$molap() {
            Lazy lazy = ISO_TIME_BASIC$delegate;
            return (DateTimeFormat)lazy.getValue();
        }

        @NotNull
        public final DateTimeFormat<DateTimeComponents> getIsoBasicFormat() {
            Lazy lazy = isoBasicFormat$delegate;
            return (DateTimeFormat)lazy.getValue();
        }

        @NotNull
        public final DateTimeFormat<DateTimeComponents> getIsoFormat() {
            Lazy lazy = isoFormat$delegate;
            return (DateTimeFormat)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

