/*
 * Decompiled with CFR 0.152.
 */
package org.molap.subset;

import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.subset.AbstractBinningDimension;
import org.molap.subset.AbstractDimension;
import org.molap.subset.MultiBinningDimension;
import org.molap.subset.SortedArraySetOperations;
import org.molap.subset.SubsetDataFrame;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\n\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u00042\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u0006:\u0005\u001e\u001f !\"BG\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00030\u00132\u0006\u0010\u001b\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0014\u0010\u001d\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u0013\u0018\u00010\u0012R\u001c\u0010\u0011\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u0013\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0014\u001a\u001e0\u0015R\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lorg/molap/subset/AbstractMultiBinningDimension;", "Row", "Column", "Value", "Bin", "Lorg/molap/subset/AbstractBinningDimension;", "Lorg/molap/subset/MultiBinningDimension;", "dataFrame", "Lorg/molap/subset/SubsetDataFrame;", "filteringCallback", "Lorg/molap/subset/AbstractDimension$FilteringCallback;", "selection", "Lcom/macrofocus/common/selection/MutableSelection;", "operation", "Lorg/molap/subset/AbstractBinningDimension$Operation;", "<init>", "(Lorg/molap/subset/SubsetDataFrame;Lorg/molap/subset/AbstractDimension$FilteringCallback;Lcom/macrofocus/common/selection/MutableSelection;Lorg/molap/subset/AbstractBinningDimension$Operation;)V", "filterSelection", "Lcom/macrofocus/common/selection/MutableSingleSelection;", "Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;", "defaultSortedArrayFilter", "Lorg/molap/subset/AbstractMultiBinningDimension$DefaultSortedArrayFilter;", "getDefaultSortedArrayFilter", "()Lorg/molap/subset/AbstractMultiBinningDimension$DefaultSortedArrayFilter;", "updateActiveIndices", "", "createSortedArrayFilter", "bin", "(Ljava/lang/Object;)Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;", "getFilterSelection", "AbstractSortedArrayFilter", "DefaultSortedArrayFilter", "BinSortedArrayFilter", "OrSortedArrayFilter", "AndSortedArrayFilter", "molap"})
public abstract class AbstractMultiBinningDimension<Row, Column, Value, Bin>
extends AbstractBinningDimension<Row, Column, Value, Bin>
implements MultiBinningDimension<Row, Bin> {
    @Nullable
    private final MutableSingleSelection<MultiBinningDimension.SortedArrayFilter<Bin>> filterSelection;
    @NotNull
    private final DefaultSortedArrayFilter defaultSortedArrayFilter;

    public AbstractMultiBinningDimension(@NotNull SubsetDataFrame<Row, Column, Value> dataFrame, @NotNull AbstractDimension.FilteringCallback<Row> filteringCallback, @Nullable MutableSelection<Row> selection, @NotNull AbstractBinningDimension.Operation operation) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(filteringCallback, (String)"filteringCallback");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        super(dataFrame, filteringCallback, selection, operation);
        this.filterSelection = (MutableSingleSelection)new SimpleSingleSelection();
        this.defaultSortedArrayFilter = new DefaultSortedArrayFilter();
        MutableSingleSelection<MultiBinningDimension.SortedArrayFilter<Bin>> mutableSingleSelection = this.filterSelection;
        Intrinsics.checkNotNull(mutableSingleSelection);
        mutableSingleSelection.addSingleSelectionListener(new SingleSelectionListener<MultiBinningDimension.SortedArrayFilter<Bin>>(){

            public void selectionChanged(SingleSelectionEvent<MultiBinningDimension.SortedArrayFilter<Bin>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.scheduleUpdateFilter();
            }
        });
    }

    @NotNull
    public DefaultSortedArrayFilter getDefaultSortedArrayFilter() {
        return this.defaultSortedArrayFilter;
    }

    @Override
    @Nullable
    public int[] updateActiveIndices() {
        int[] nArray;
        if (this.filterSelection != null && this.filterSelection.isActive()) {
            Object object = this.filterSelection.getSelected();
            Intrinsics.checkNotNull((Object)object);
            nArray = ((MultiBinningDimension.SortedArrayFilter)object).evaluate();
        } else {
            nArray = super.updateActiveIndices();
        }
        return nArray;
    }

    @Override
    @NotNull
    public MultiBinningDimension.SortedArrayFilter<Bin> createSortedArrayFilter(Bin bin) {
        return new BinSortedArrayFilter(bin);
    }

    @Nullable
    public final MutableSingleSelection<MultiBinningDimension.SortedArrayFilter<Bin>> getFilterSelection() {
        return this.filterSelection;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00a6\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00030\u00012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u00010\u0006H\u0016J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00030\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00030\u0001H\u0016J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00030\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00030\u0001H\u0016J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00030\u00012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u00010\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/subset/AbstractMultiBinningDimension$AbstractSortedArrayFilter;", "Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;", "<init>", "(Lorg/molap/subset/AbstractMultiBinningDimension;)V", "or", "others", "", "other", "and", "molap"})
    public abstract class AbstractSortedArrayFilter
    implements MultiBinningDimension.SortedArrayFilter<Bin> {
        @Override
        @NotNull
        public MultiBinningDimension.SortedArrayFilter<Bin> or(@NotNull Iterable<? extends MultiBinningDimension.SortedArrayFilter<Bin>> others) {
            Intrinsics.checkNotNullParameter(others, (String)"others");
            return new OrSortedArrayFilter((MultiBinningDimension.SortedArrayFilter)this, others);
        }

        @Override
        @NotNull
        public MultiBinningDimension.SortedArrayFilter<Bin> or(@NotNull MultiBinningDimension.SortedArrayFilter<Bin> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            MultiBinningDimension.SortedArrayFilter[] sortedArrayFilterArray = new MultiBinningDimension.SortedArrayFilter[]{other};
            return new OrSortedArrayFilter((MultiBinningDimension.SortedArrayFilter)this, sortedArrayFilterArray);
        }

        @Override
        @NotNull
        public MultiBinningDimension.SortedArrayFilter<Bin> and(@NotNull MultiBinningDimension.SortedArrayFilter<Bin> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            MultiBinningDimension.SortedArrayFilter[] sortedArrayFilterArray = new MultiBinningDimension.SortedArrayFilter[]{other};
            return new AndSortedArrayFilter((MultiBinningDimension.SortedArrayFilter)this, sortedArrayFilterArray);
        }

        @Override
        @NotNull
        public MultiBinningDimension.SortedArrayFilter<Bin> and(@NotNull Iterable<? extends MultiBinningDimension.SortedArrayFilter<Bin>> others) {
            Intrinsics.checkNotNullParameter(others, (String)"others");
            return new OrSortedArrayFilter((MultiBinningDimension.SortedArrayFilter)this, others);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0002B+\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00030\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u00040\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB7\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00030\u0004\u0012\u001e\u0010\u0005\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00030\u00040\t\"\b\u0012\u0004\u0012\u00028\u00030\u0004\u00a2\u0006\u0004\b\u0007\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u00040\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/molap/subset/AbstractMultiBinningDimension$AndSortedArrayFilter;", "Lorg/molap/subset/AbstractMultiBinningDimension$AbstractSortedArrayFilter;", "Lorg/molap/subset/AbstractMultiBinningDimension;", "first", "Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;", "filters", "", "<init>", "(Lorg/molap/subset/AbstractMultiBinningDimension;Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;Ljava/lang/Iterable;)V", "", "(Lorg/molap/subset/AbstractMultiBinningDimension;Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;[Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;)V", "evaluate", "", "toString", "", "molap"})
    public final class AndSortedArrayFilter
    extends AbstractSortedArrayFilter {
        @Nullable
        private MultiBinningDimension.SortedArrayFilter<Bin> first;
        @NotNull
        private Iterable<? extends MultiBinningDimension.SortedArrayFilter<Bin>> filters;

        public AndSortedArrayFilter(@NotNull MultiBinningDimension.SortedArrayFilter<Bin> first, Iterable<? extends MultiBinningDimension.SortedArrayFilter<Bin>> filters) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            this.first = first;
            this.filters = filters;
        }

        public AndSortedArrayFilter(@NotNull MultiBinningDimension.SortedArrayFilter<Bin> first, MultiBinningDimension.SortedArrayFilter<Bin> ... filters) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            this.first = first;
            this.filters = ArraysKt.asIterable((Object[])filters);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public int[] evaluate() {
            void var1_1;
            if (!AbstractMultiBinningDimension.this.getInverseFilter()) {
                MultiBinningDimension.SortedArrayFilter sortedArrayFilter = this.first;
                Intrinsics.checkNotNull(sortedArrayFilter);
                int[] current = sortedArrayFilter.evaluate();
                for (MultiBinningDimension.SortedArrayFilter filter : this.filters) {
                    int[] evaluation = filter.evaluate();
                    if (current != null) {
                        if (evaluation == null) continue;
                        current = SortedArraySetOperations.INSTANCE.intersectSortedArrays(current, evaluation);
                        continue;
                    }
                    current = evaluation;
                }
            } else {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            return var1_1;
        }

        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder("And(");
            sb.append(this.first);
            for (MultiBinningDimension.SortedArrayFilter filter : this.filters) {
                sb.append(" ").append(filter);
            }
            sb.append(')');
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0003\u001a\u00028\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/molap/subset/AbstractMultiBinningDimension$BinSortedArrayFilter;", "Lorg/molap/subset/AbstractMultiBinningDimension$AbstractSortedArrayFilter;", "Lorg/molap/subset/AbstractMultiBinningDimension;", "bin", "<init>", "(Lorg/molap/subset/AbstractMultiBinningDimension;Ljava/lang/Object;)V", "Ljava/lang/Object;", "evaluate", "", "toString", "", "molap"})
    public final class BinSortedArrayFilter
    extends AbstractSortedArrayFilter {
        private final Bin bin;

        public BinSortedArrayFilter(Bin bin) {
            this.bin = bin;
        }

        @Override
        @Nullable
        public int[] evaluate() {
            Object object;
            if (!AbstractMultiBinningDimension.this.getInverseFilter()) {
                int[] rows;
                Map map = AbstractMultiBinningDimension.this.getIndex();
                Intrinsics.checkNotNull(map);
                object = rows = map.get(this.bin);
                if (rows == null) {
                    object = new int[]{};
                }
            } else {
                Map map = AbstractMultiBinningDimension.this.getIndex();
                Intrinsics.checkNotNull(map);
                int[] rows = map.get(this.bin);
                object = rows != null ? SortedArraySetOperations.INSTANCE.diffSortedTIntArrays(AbstractMultiBinningDimension.this.getDataFrame().getUnfilteredDataFrame().getRowCount(), rows) : null;
            }
            return object;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.bin);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/subset/AbstractMultiBinningDimension$DefaultSortedArrayFilter;", "Lorg/molap/subset/AbstractMultiBinningDimension$AbstractSortedArrayFilter;", "Lorg/molap/subset/AbstractMultiBinningDimension;", "<init>", "(Lorg/molap/subset/AbstractMultiBinningDimension;)V", "evaluate", "", "toString", "", "molap"})
    public final class DefaultSortedArrayFilter
    extends AbstractSortedArrayFilter {
        @Override
        @Nullable
        public int[] evaluate() {
            return AbstractMultiBinningDimension.super.updateActiveIndices();
        }

        @NotNull
        public String toString() {
            return "Default";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0002B+\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00030\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u00040\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB7\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00030\u0004\u0012\u001e\u0010\u0005\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00030\u00040\t\"\b\u0012\u0004\u0012\u00028\u00030\u0004\u00a2\u0006\u0004\b\u0007\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u00040\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/molap/subset/AbstractMultiBinningDimension$OrSortedArrayFilter;", "Lorg/molap/subset/AbstractMultiBinningDimension$AbstractSortedArrayFilter;", "Lorg/molap/subset/AbstractMultiBinningDimension;", "first", "Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;", "filters", "", "<init>", "(Lorg/molap/subset/AbstractMultiBinningDimension;Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;Ljava/lang/Iterable;)V", "", "(Lorg/molap/subset/AbstractMultiBinningDimension;Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;[Lorg/molap/subset/MultiBinningDimension$SortedArrayFilter;)V", "evaluate", "", "toString", "", "molap"})
    public final class OrSortedArrayFilter
    extends AbstractSortedArrayFilter {
        @Nullable
        private MultiBinningDimension.SortedArrayFilter<Bin> first;
        @NotNull
        private Iterable<? extends MultiBinningDimension.SortedArrayFilter<Bin>> filters;

        public OrSortedArrayFilter(@NotNull MultiBinningDimension.SortedArrayFilter<Bin> first, Iterable<? extends MultiBinningDimension.SortedArrayFilter<Bin>> filters) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            this.first = first;
            this.filters = filters;
        }

        public OrSortedArrayFilter(@NotNull MultiBinningDimension.SortedArrayFilter<Bin> first, MultiBinningDimension.SortedArrayFilter<Bin> ... filters) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            this.first = first;
            this.filters = ArraysKt.asIterable((Object[])filters);
        }

        @Override
        @Nullable
        public int[] evaluate() {
            int[] nArray;
            if (!AbstractMultiBinningDimension.this.getInverseFilter()) {
                MultiBinningDimension.SortedArrayFilter sortedArrayFilter = this.first;
                Intrinsics.checkNotNull(sortedArrayFilter);
                int[] current = sortedArrayFilter.evaluate();
                if (current != null) {
                    for (MultiBinningDimension.SortedArrayFilter filter : this.filters) {
                        int[] evaluation;
                        if (filter.evaluate() == null) {
                            return null;
                        }
                        current = SortedArraySetOperations.INSTANCE.unionSortedArrays(current, evaluation);
                    }
                    nArray = current;
                } else {
                    nArray = null;
                }
            } else {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            return nArray;
        }

        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder("Or(");
            sb.append(this.first);
            for (MultiBinningDimension.SortedArrayFilter filter : this.filters) {
                sb.append(" ").append(filter);
            }
            sb.append(')');
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

