/*
 * Decompiled with CFR 0.152.
 */
package org.molap.subset;

import com.macrofocus.common.annotation.Synchronized;
import com.macrofocus.common.collection.ObjectIntMap;
import com.macrofocus.common.collection.RandomAccessIterable;
import com.macrofocus.common.collection.RandomAccessIterableKt;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.subset.AbstractBinningDimension;
import org.molap.subset.AbstractDimension;
import org.molap.subset.CategoricalDimension;
import org.molap.subset.DefaultGroup;
import org.molap.subset.DimensionEvent;
import org.molap.subset.Group;
import org.molap.subset.Reducer;
import org.molap.subset.SingleBinningDimension;
import org.molap.subset.SubsetDataFrame;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u00042\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0006B]\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0001\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r\u0012\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00028\u00032\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u001b\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00030&2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00028\u00032\u0006\u0010#\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010$J\u0012\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0017J(\u0010-\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00030.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000300H\u0016J\b\u00101\u001a\u00020*H\u0016J2\u00102\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020,032\u001c\u00104\u001a\u0018\u0012\u0004\u0012\u00028\u0003\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020706j\u0002`805H\u0004J\b\u00109\u001a\u00020\u001bH\u0016R\u0010\u0010\t\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u000f2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u000f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006:"}, d2={"Lorg/molap/subset/DefaultBinningDimension;", "Row", "Column", "Value", "Bin", "Lorg/molap/subset/AbstractBinningDimension;", "Lorg/molap/subset/CategoricalDimension;", "dataFrame", "Lorg/molap/subset/SubsetDataFrame;", "column", "filteringCallback", "Lorg/molap/subset/AbstractDimension$FilteringCallback;", "selection", "Lcom/macrofocus/common/selection/MutableSelection;", "binningStrategy", "Lorg/molap/subset/SingleBinningDimension$SingleBinningStrategy;", "<init>", "(Lorg/molap/subset/SubsetDataFrame;Ljava/lang/Object;Lorg/molap/subset/AbstractDimension$FilteringCallback;Lcom/macrofocus/common/selection/MutableSelection;Lorg/molap/subset/SingleBinningDimension$SingleBinningStrategy;)V", "Ljava/lang/Object;", "selectionListener", "Lcom/macrofocus/common/selection/SelectionListener;", "value", "getBinningStrategy", "()Lorg/molap/subset/SingleBinningDimension$SingleBinningStrategy;", "setBinningStrategy", "(Lorg/molap/subset/SingleBinningDimension$SingleBinningStrategy;)V", "name", "", "getName", "()Ljava/lang/String;", "containsBin", "", "bin", "(Ljava/lang/Object;)Z", "getBin", "row", "(Ljava/lang/Object;)Ljava/lang/Object;", "getBins", "", "(Ljava/lang/Object;)Ljava/lang/Iterable;", "rowToBin", "reduce", "", "otherActiveIndices", "", "getGroup", "Lorg/molap/subset/Group;", "reducer", "Lorg/molap/subset/Reducer;", "materializeIndex", "createMap", "", "map", "", "", "", "Lcom/macrofocus/common/collection/TIntList;", "toString", "molap"})
public class DefaultBinningDimension<Row, Column, Value, Bin>
extends AbstractBinningDimension<Row, Column, Value, Bin>
implements CategoricalDimension<Row, Column, Bin> {
    private final Column column;
    @NotNull
    private final SelectionListener<Row> selectionListener;
    @Nullable
    private SingleBinningDimension.SingleBinningStrategy<Row, Bin> binningStrategy;

    public DefaultBinningDimension(@NotNull SubsetDataFrame<Row, Column, Value> dataFrame, Column column, @NotNull AbstractDimension.FilteringCallback<Row> filteringCallback, @Nullable MutableSelection<Row> selection, @Nullable SingleBinningDimension.SingleBinningStrategy<Row, Bin> binningStrategy2) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(filteringCallback, (String)"filteringCallback");
        super(dataFrame, filteringCallback, selection, AbstractBinningDimension.Operation.Or);
        this.column = column;
        this.selectionListener = new SelectionListener<Row>(binningStrategy2, this){
            final /* synthetic */ SingleBinningDimension.SingleBinningStrategy<Row, Bin> $binningStrategy;
            final /* synthetic */ DefaultBinningDimension<Row, Column, Value, Bin> this$0;
            {
                this.$binningStrategy = $binningStrategy;
                this.this$0 = $receiver;
            }

            public void selectionChanged(SelectionEvent<Row> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (this.$binningStrategy != null) {
                    for (T row : event.getAffected()) {
                        if (!this.$binningStrategy.isBinnable(row)) continue;
                        Bin bin = this.this$0.rowToBin(row);
                        if (event.getModel().isSelected(row)) {
                            this.this$0.getSelectedCounts().adjustOrPutValue(bin, 1, 1);
                            continue;
                        }
                        this.this$0.getSelectedCounts().adjustValue(bin, -1);
                    }
                    this.this$0.notifySelectedCountChanged();
                }
            }
        };
        if (selection != null) {
            selection.addSelectionListener(this.selectionListener);
        }
        this.binningStrategy = binningStrategy2;
    }

    @Override
    @Nullable
    public SingleBinningDimension.SingleBinningStrategy<Row, Bin> getBinningStrategy() {
        return this.binningStrategy;
    }

    @Override
    public void setBinningStrategy(@Nullable SingleBinningDimension.SingleBinningStrategy<Row, Bin> value) {
        if (this.binningStrategy != value) {
            this.setUpdateFilterImmediately(true);
            this.filterAll();
            this.binningStrategy = value;
            this.markDirty();
            this.setUpdateFilterImmediately(false);
            this.notifyDimensionChanged(new DimensionEvent(this, null, null));
        }
    }

    @Override
    @Nullable
    public String getName() {
        return String.valueOf(this.column);
    }

    @Override
    public boolean containsBin(Bin bin) {
        Map map = this.getIndex();
        Intrinsics.checkNotNull(map);
        return map.containsKey(bin);
    }

    @Override
    public Bin getBin(Row row) {
        return this.rowToBin(row);
    }

    @Override
    @NotNull
    public Iterable<Bin> getBins(Row row) {
        return CollectionsKt.listOf(this.rowToBin(row));
    }

    protected final Bin rowToBin(Row row) {
        SingleBinningDimension.SingleBinningStrategy<Row, Bin> singleBinningStrategy = this.getBinningStrategy();
        Intrinsics.checkNotNull(singleBinningStrategy);
        return singleBinningStrategy.rowToBin(row);
    }

    @Override
    @Synchronized
    public void reduce(@Nullable int[] otherActiveIndices) {
        if (this.getBinningStrategy() != null) {
            int[] oldIndices = otherActiveIndices;
            this.setOtherActiveIndices(otherActiveIndices);
            if (otherActiveIndices != null) {
                Bin bin;
                int[] filtered = this.getDataFrame().computeFiltered(oldIndices, otherActiveIndices);
                int[] unfiltered = this.getDataFrame().computeUnfiltered(oldIndices, otherActiveIndices);
                System.out.println((Object)("Processing " + filtered + " and " + unfiltered + " with " + this.getBinningStrategy()));
                for (Object row : new AbstractDimension.IndicesIterable(this.getDataFrame().getUnfilteredDataFrame(), filtered)) {
                    System.out.println((Object)("Processing " + row + " with " + this.getBinningStrategy()));
                    SingleBinningDimension.SingleBinningStrategy singleBinningStrategy = this.getBinningStrategy();
                    Intrinsics.checkNotNull(singleBinningStrategy);
                    if (!singleBinningStrategy.isBinnable(row)) continue;
                    bin = this.rowToBin(row);
                    ObjectIntMap objectIntMap = this.getFilterCounts();
                    Intrinsics.checkNotNull(objectIntMap);
                    objectIntMap.adjustOrPutValue(bin, 1, 1);
                    if (this.getGroups() == null) continue;
                    Map map = this.getGroups();
                    Intrinsics.checkNotNull(map);
                    for (Group group : map.values()) {
                        group.remove(bin, row);
                    }
                }
                for (Object row : new AbstractDimension.IndicesIterable(this.getDataFrame().getUnfilteredDataFrame(), unfiltered)) {
                    SingleBinningDimension.SingleBinningStrategy singleBinningStrategy = this.getBinningStrategy();
                    Intrinsics.checkNotNull(singleBinningStrategy);
                    if (!singleBinningStrategy.isBinnable(row)) continue;
                    bin = this.rowToBin(row);
                    ObjectIntMap objectIntMap = this.getFilterCounts();
                    Intrinsics.checkNotNull(objectIntMap);
                    if (objectIntMap.get(bin) > 1) {
                        ObjectIntMap objectIntMap2 = this.getFilterCounts();
                        Intrinsics.checkNotNull(objectIntMap2);
                        objectIntMap2.adjustValue(bin, -1);
                    } else {
                        ObjectIntMap objectIntMap3 = this.getFilterCounts();
                        Intrinsics.checkNotNull(objectIntMap3);
                        objectIntMap3.remove(bin);
                    }
                    if (this.getGroups() == null) continue;
                    Map map = this.getGroups();
                    Intrinsics.checkNotNull(map);
                    for (Group group : map.values()) {
                        group.add(bin, row);
                    }
                }
                this.updateActive();
                this.notifyDimensionChanged(new DimensionEvent(this, new AbstractDimension.IndicesIterable(this.getDataFrame().getUnfilteredDataFrame(), filtered), new AbstractDimension.IndicesIterable(this.getDataFrame().getUnfilteredDataFrame(), unfiltered)));
            } else {
                ObjectIntMap objectIntMap = this.getFilterCounts();
                Intrinsics.checkNotNull(objectIntMap);
                objectIntMap.clear();
                if (this.getGroups() != null) {
                    Map map = this.getGroups();
                    Intrinsics.checkNotNull(map);
                    for (Group group : map.values()) {
                        group.reset();
                    }
                }
                this.updateActive();
                this.notifyDimensionChanged(new DimensionEvent(this, new AbstractDimension.IndicesIterable(this.getDataFrame().getUnfilteredDataFrame(), new AbstractDimension.IndicesSupplier(this, oldIndices, otherActiveIndices){
                    final /* synthetic */ DefaultBinningDimension<Row, Column, Value, Bin> this$0;
                    final /* synthetic */ int[] $oldIndices;
                    final /* synthetic */ int[] $otherActiveIndices;
                    {
                        this.this$0 = $receiver;
                        this.$oldIndices = $oldIndices;
                        this.$otherActiveIndices = $otherActiveIndices;
                    }

                    public int[] get() {
                        return this.this$0.getDataFrame().computeFiltered(this.$oldIndices, this.$otherActiveIndices);
                    }
                }), new AbstractDimension.IndicesIterable(this.getDataFrame().getUnfilteredDataFrame(), new AbstractDimension.IndicesSupplier(this, oldIndices, otherActiveIndices){
                    final /* synthetic */ DefaultBinningDimension<Row, Column, Value, Bin> this$0;
                    final /* synthetic */ int[] $oldIndices;
                    final /* synthetic */ int[] $otherActiveIndices;
                    {
                        this.this$0 = $receiver;
                        this.$oldIndices = $oldIndices;
                        this.$otherActiveIndices = $otherActiveIndices;
                    }

                    public int[] get() {
                        return this.this$0.getDataFrame().computeUnfiltered(this.$oldIndices, this.$otherActiveIndices);
                    }
                })));
            }
        }
    }

    @Override
    @NotNull
    public Group<Row, Bin> getGroup(@NotNull Reducer<Row, Bin> reducer) {
        Intrinsics.checkNotNullParameter(reducer, (String)"reducer");
        if (this.getGroups() == null) {
            this.setGroups(new HashMap());
        } else {
            Map map = this.getGroups();
            Intrinsics.checkNotNull(map);
            if (map.containsKey(reducer)) {
                Map map2 = this.getGroups();
                Intrinsics.checkNotNull(map2);
                Group group = map2.get(reducer);
                Intrinsics.checkNotNull(group);
                return group;
            }
        }
        RandomAccessIterable randomAccessIterable = this.getBins();
        Intrinsics.checkNotNull(randomAccessIterable);
        int n = randomAccessIterable.size();
        DataFrame dataFrame = this.getDataFrame().getUnfilteredDataFrame();
        SingleBinningDimension.SingleBinningStrategy<Row, Bin> singleBinningStrategy = this.getBinningStrategy();
        Intrinsics.checkNotNull(singleBinningStrategy);
        Group group = new DefaultGroup<Row, Bin>(n, reducer, dataFrame, singleBinningStrategy);
        Map map = this.getGroups();
        Intrinsics.checkNotNull(map);
        map.put(reducer, group);
        return group;
    }

    @Override
    public void materializeIndex() {
        Map index = new HashMap();
        if (this.getBinningStrategy() != null) {
            this.getSelectedCounts().clear();
            int size = this.getDataFrame().getUnfilteredDataFrame().getRowCount();
            for (int address = 0; address < size; ++address) {
                Object row = this.getDataFrame().getUnfilteredDataFrame().getRowKey(address);
                SingleBinningDimension.SingleBinningStrategy singleBinningStrategy = this.getBinningStrategy();
                Intrinsics.checkNotNull(singleBinningStrategy);
                if (!singleBinningStrategy.isBinnable(row)) continue;
                Iterator bin = this.rowToBin(row);
                List indices = null;
                if (index.containsKey(bin)) {
                    indices = (List)index.get(bin);
                } else {
                    indices = new ArrayList();
                    index.put(bin, indices);
                }
                List list = indices;
                Intrinsics.checkNotNull((Object)list);
                list.add(address);
                if (this.getSelection() == null) continue;
                MutableSelection mutableSelection = this.getSelection();
                Intrinsics.checkNotNull(mutableSelection);
                if (!mutableSelection.isSelected(row)) continue;
                this.getSelectedCounts().adjustOrPutValue(bin, 1, 1);
            }
        }
        Map<Bin, int[]> arrayIndex = this.createMap(index);
        int maxValueCount = 0;
        int sumValueCount = 0;
        if (this.getBinningStrategy() != null) {
            for (Map.Entry entry : index.entrySet()) {
                List value;
                Object key = entry.getKey();
                List list = value = (List)entry.getValue();
                Intrinsics.checkNotNull((Object)list);
                int[] indices = CollectionsKt.toIntArray((Collection)list);
                arrayIndex.put(key, indices);
                if (indices.length > maxValueCount) {
                    maxValueCount = indices.length;
                }
                sumValueCount += indices.length;
            }
        }
        this.setMaxValueCount(maxValueCount);
        this.setSumValueCount(sumValueCount);
        List bins = new ArrayList(arrayIndex.keySet());
        this.setIndex(arrayIndex);
        this.setBins(RandomAccessIterableKt.asRandomAccessIterable((List)bins));
        this.setActiveIndices(this.updateActiveIndices());
        this.updateActive();
    }

    @NotNull
    protected final Map<Bin, int[]> createMap(@NotNull Map<Bin, ? extends List<Integer>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        return new HashMap(map.size());
    }

    @NotNull
    public String toString() {
        return "Dimension{column=" + this.column + "}";
    }
}

