/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter.parquet;

import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.Preconditions;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.exporter.parquet.DataFrameSchemaConverter;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 )*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0002)*B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B-\b\u0017\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ7\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020 2\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\u0006\u0010\u001d\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010!JK\u0010\"\u001a\u00020\u001b\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010 2\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\t2\u0006\u0010\u001d\u001a\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010!JS\u0010#\u001a\u00020\u001b\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\b\u0010$\u001a\u0004\u0018\u00010%2\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\t2\u0006\u0010&\u001a\u0002H\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010'JS\u0010(\u001a\u00020\u001b\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\b\u0010$\u001a\u0004\u0018\u00010%2\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\t2\u0006\u0010&\u001a\u0002H\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010'R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/molap/exporter/parquet/DataFrameWriteSupport;", "R", "C", "V", "Lorg/apache/parquet/hadoop/api/WriteSupport;", "()V", "schema", "Lorg/apache/parquet/schema/MessageType;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "(Lorg/apache/parquet/schema/MessageType;Lorg/molap/dataframe/DataFrame;)V", "recordConsumer", "Lorg/apache/parquet/io/api/RecordConsumer;", "rootSchema", "rootdataFrame", "fromString", "Lorg/apache/parquet/io/api/Binary;", "value", "", "fromURL", "getName", "", "init", "Lorg/apache/parquet/hadoop/api/WriteSupport$WriteContext;", "configuration", "Lorg/apache/hadoop/conf/Configuration;", "prepareForWrite", "", "write", "record", "(Ljava/lang/Object;)V", "writeRecord", "Lorg/apache/parquet/schema/GroupType;", "(Lorg/apache/parquet/schema/GroupType;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)V", "writeRecordFields", "writeValue", "type", "Lorg/apache/parquet/schema/Type;", "column", "(Lorg/apache/parquet/schema/Type;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "writeValueWithoutConversion", "Companion", "ListWriter", "molap-parquet"})
public final class DataFrameWriteSupport<R, C, V>
extends WriteSupport<R> {
    private RecordConsumer recordConsumer;
    private MessageType rootSchema;
    private DataFrame<R, C, V> rootdataFrame;
    private static final String MAP_REPEATED_NAME = "key_value";
    private static final String MAP_KEY_NAME = "key";
    private static final String MAP_VALUE_NAME = "value";
    private static final String LIST_REPEATED_NAME = "list";
    private static final String OLD_LIST_REPEATED_NAME = "array";
    @NotNull
    public static final String LIST_ELEMENT_NAME = "element";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return "avro";
    }

    @NotNull
    public WriteSupport.WriteContext init(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (this.rootdataFrame == null) {
            DataFrameSchemaConverter dataFrameSchemaConverter = new DataFrameSchemaConverter();
            DataFrame<R, C, V> dataFrame = this.rootdataFrame;
            Intrinsics.checkNotNull(dataFrame);
            this.rootSchema = dataFrameSchemaConverter.convert(dataFrame);
        }
        Map extraMetaData = new HashMap();
        return new WriteSupport.WriteContext(this.rootSchema, extraMetaData);
    }

    public void prepareForWrite(@NotNull RecordConsumer recordConsumer) {
        Intrinsics.checkNotNullParameter((Object)recordConsumer, (String)"recordConsumer");
        this.recordConsumer = recordConsumer;
    }

    public void write(R record) {
        RecordConsumer recordConsumer = this.recordConsumer;
        Intrinsics.checkNotNull((Object)recordConsumer);
        recordConsumer.startMessage();
        GroupType groupType = (GroupType)this.rootSchema;
        DataFrame<R, C, V> dataFrame = this.rootdataFrame;
        Intrinsics.checkNotNull(dataFrame);
        this.writeRecordFields(groupType, dataFrame, record);
        RecordConsumer recordConsumer2 = this.recordConsumer;
        Intrinsics.checkNotNull((Object)recordConsumer2);
        recordConsumer2.endMessage();
    }

    private final void writeRecord(GroupType schema, DataFrame<R, C, V> dataFrame, R record) {
        RecordConsumer recordConsumer = this.recordConsumer;
        Intrinsics.checkNotNull((Object)recordConsumer);
        recordConsumer.startGroup();
        this.writeRecordFields(schema, dataFrame, record);
        RecordConsumer recordConsumer2 = this.recordConsumer;
        Intrinsics.checkNotNull((Object)recordConsumer2);
        recordConsumer2.endGroup();
    }

    private final <R, C, V> void writeRecordFields(GroupType schema, DataFrame<R, C, V> dataFrame, R record) {
        GroupType groupType = schema;
        Intrinsics.checkNotNull((Object)groupType);
        List fields = groupType.getFields();
        int index = 0;
        for (Object column : dataFrame.columns()) {
            Type fieldType = (Type)fields.get(index);
            Object value = dataFrame.getValueAt(record, column);
            if (value != null) {
                String columnName = dataFrame.getColumnName(column);
                boolean bl = false;
                System.out.println((Object)columnName);
                RecordConsumer recordConsumer = this.recordConsumer;
                Intrinsics.checkNotNull((Object)recordConsumer);
                recordConsumer.startField(columnName, index);
                this.writeValue(null, dataFrame, column, value);
                RecordConsumer recordConsumer2 = this.recordConsumer;
                Intrinsics.checkNotNull((Object)recordConsumer2);
                recordConsumer2.endField(columnName, index);
            } else if (fieldType.isRepetition(Type.Repetition.REQUIRED)) {
                throw (Throwable)new RuntimeException("Null-value for required field: " + column);
            }
            ++index;
        }
    }

    private final <R, C, V> void writeValue(Type type, DataFrame<R, C, V> dataFrame, C column, Object value) {
        this.writeValueWithoutConversion(type, dataFrame, column, value);
    }

    private final <R, C, V> void writeValueWithoutConversion(Type type, DataFrame<R, C, V> dataFrame, C column, Object value) {
        KClass columnClass = dataFrame.getColumnClass(column);
        if (Intrinsics.areEqual(Boolean.TYPE, (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Object object = value;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            recordConsumer.addBoolean(((Boolean)object).booleanValue());
        } else if (Intrinsics.areEqual(Integer.TYPE, (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Object object = value;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            recordConsumer.addInteger(((Number)object).intValue());
        } else if (value instanceof Character) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addInteger((int)((Character)value).charValue());
        } else if (Intrinsics.areEqual(Long.TYPE, (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Object object = value;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            recordConsumer.addLong(((Number)object).longValue());
        } else if (Intrinsics.areEqual(Float.TYPE, (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Object object = value;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            recordConsumer.addFloat(((Number)object).floatValue());
        } else if (Intrinsics.areEqual(Double.TYPE, (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Object object = value;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            recordConsumer.addDouble(((Number)object).doubleValue());
        } else if (Intrinsics.areEqual(byte[].class, (Object)columnClass)) {
            if (value instanceof byte[]) {
                RecordConsumer recordConsumer = this.recordConsumer;
                Intrinsics.checkNotNull((Object)recordConsumer);
                recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])((byte[])value)));
            } else {
                RecordConsumer recordConsumer = this.recordConsumer;
                Intrinsics.checkNotNull((Object)recordConsumer);
                Object object = value;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
                }
                recordConsumer.addBinary(Binary.fromReusedByteBuffer((ByteBuffer)((ByteBuffer)object)));
            }
        } else if (Intrinsics.areEqual(String.class, (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(this.fromString(value));
        } else if (Intrinsics.areEqual(Enum.class, (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(Binary.fromString((String)value.toString()));
        } else if (Intrinsics.areEqual(URL.class, (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(this.fromURL(value));
        }
    }

    private final Binary fromString(Object value) {
        Binary binary;
        if (value instanceof CharSequence) {
            Binary binary2 = Binary.fromCharSequence((CharSequence)((CharSequence)value));
            binary = binary2;
            Intrinsics.checkNotNullExpressionValue((Object)binary2, (String)"Binary.fromCharSequence(value)");
        } else {
            Binary binary3 = Binary.fromCharSequence((CharSequence)value.toString());
            binary = binary3;
            Intrinsics.checkNotNullExpressionValue((Object)binary3, (String)"Binary.fromCharSequence(value.toString())");
        }
        return binary;
    }

    private final Binary fromURL(Object value) {
        return value instanceof URL ? Binary.fromCharSequence((CharSequence)((URL)value).toExternalForm()) : null;
    }

    public DataFrameWriteSupport() {
    }

    @Deprecated(message="will be removed in 2.0.0")
    public DataFrameWriteSupport(@Nullable MessageType schema, @Nullable DataFrame<R, C, V> dataFrame) {
        this.rootSchema = schema;
        this.rootdataFrame = dataFrame;
    }

    public static final /* synthetic */ void access$setRecordConsumer$p(DataFrameWriteSupport $this, RecordConsumer recordConsumer) {
        $this.recordConsumer = recordConsumer;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H$J\b\u0010\u0005\u001a\u00020\u0004H$J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\nH\u0004J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\fH\u0004J:\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H$J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0015H\u0004J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0019H\u0004J>\u0010\u001a\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00112\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u0001J2\u0010\u001f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0001J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020!H\u0004JC\u0010\"\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00112\u0010\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010#H$\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020&H\u0004\u00a8\u0006'"}, d2={"Lorg/molap/exporter/parquet/DataFrameWriteSupport$ListWriter;", "", "(Lorg/molap/exporter/parquet/DataFrameWriteSupport;)V", "endArray", "", "startArray", "writeBooleanArray", "array", "", "writeByteArray", "", "writeCharArray", "", "writeCollection", "type", "Lorg/apache/parquet/schema/GroupType;", "schema", "Lorg/molap/dataframe/DataFrame;", "collection", "", "writeDoubleArray", "", "writeFloatArray", "", "writeIntArray", "", "writeJavaArray", "dataFrame", "arrayClass", "Ljava/lang/Class;", "value", "writeList", "writeLongArray", "", "writeObjectArray", "", "(Lorg/apache/parquet/schema/GroupType;Lorg/molap/dataframe/DataFrame;[Ljava/lang/Object;)V", "writeShortArray", "", "molap-parquet"})
    private abstract class ListWriter {
        protected abstract void writeCollection(@Nullable GroupType var1, @NotNull DataFrame<R, C, V> var2, @Nullable Collection<?> var3);

        protected abstract void writeObjectArray(@Nullable GroupType var1, @NotNull DataFrame<R, C, V> var2, @Nullable Object[] var3);

        protected abstract void startArray();

        protected abstract void endArray();

        public final void writeList(@Nullable GroupType schema, @NotNull DataFrame<R, C, V> dataFrame, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter((Object)value, (String)DataFrameWriteSupport.MAP_VALUE_NAME);
            RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.startGroup();
            if (value instanceof Collection) {
                this.writeCollection(schema, dataFrame, (Collection)value);
            } else {
                Class<?> arrayClass = value.getClass();
                Preconditions.checkArgument((boolean)arrayClass.isArray(), (String)("Cannot write unless collection or array: " + arrayClass.getName()));
                this.writeJavaArray(schema, dataFrame, arrayClass, value);
            }
            RecordConsumer recordConsumer2 = DataFrameWriteSupport.this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer2);
            recordConsumer2.endGroup();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void writeJavaArray(@Nullable GroupType schema, @NotNull DataFrame<R, C, V> dataFrame, @NotNull Class<?> arrayClass, @NotNull Object value) {
            Class<?> elementClass;
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter(arrayClass, (String)"arrayClass");
            Intrinsics.checkNotNullParameter((Object)value, (String)DataFrameWriteSupport.MAP_VALUE_NAME);
            Class<?> clazz = elementClass = arrayClass.getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"elementClass");
            if (!clazz.isPrimitive()) {
                this.writeObjectArray(schema, dataFrame, (Object[])value);
                return;
            }
            KClass columnClass = dataFrame.getColumnClass(null);
            if (Intrinsics.areEqual(Boolean.TYPE, (Object)columnClass)) {
                Preconditions.checkArgument((boolean)Intrinsics.areEqual(elementClass, Boolean.TYPE), (String)("Cannot write as boolean array: " + arrayClass.getName()));
                this.writeBooleanArray((boolean[])value);
                return;
            } else if (Intrinsics.areEqual(Integer.TYPE, (Object)columnClass)) {
                if (Intrinsics.areEqual(elementClass, Byte.TYPE)) {
                    this.writeByteArray((byte[])value);
                    return;
                } else if (Intrinsics.areEqual(elementClass, Character.TYPE)) {
                    this.writeCharArray((char[])value);
                    return;
                } else if (Intrinsics.areEqual(elementClass, Short.TYPE)) {
                    this.writeShortArray((short[])value);
                    return;
                } else {
                    if (!Intrinsics.areEqual(elementClass, Integer.TYPE)) throw (Throwable)new IllegalArgumentException("Cannot write as an int array: " + arrayClass.getName());
                    this.writeIntArray((int[])value);
                }
                return;
            } else if (Intrinsics.areEqual(Long.TYPE, (Object)columnClass)) {
                Preconditions.checkArgument((boolean)Intrinsics.areEqual(elementClass, Long.TYPE), (String)("Cannot write as long array: " + arrayClass.getName()));
                this.writeLongArray((long[])value);
                return;
            } else if (Intrinsics.areEqual(Float.TYPE, (Object)columnClass)) {
                Preconditions.checkArgument((boolean)Intrinsics.areEqual(elementClass, Float.TYPE), (String)("Cannot write as float array: " + arrayClass.getName()));
                this.writeFloatArray((float[])value);
                return;
            } else {
                if (!Intrinsics.areEqual(Double.TYPE, (Object)columnClass)) throw (Throwable)new IllegalArgumentException("Cannot write " + dataFrame.getColumnClass(null).toString() + " array: " + arrayClass.getName());
                Preconditions.checkArgument((boolean)Intrinsics.areEqual(elementClass, Double.TYPE), (String)("Cannot write as double array: " + arrayClass.getName()));
                this.writeDoubleArray((double[])value);
            }
        }

        protected final void writeBooleanArray(@NotNull boolean[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (boolean element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addBoolean(element);
                }
                this.endArray();
            }
        }

        protected final void writeByteArray(@NotNull byte[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (byte element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected final void writeShortArray(@NotNull short[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (short element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected final void writeCharArray(@NotNull char[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (char element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected final void writeIntArray(@NotNull int[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (int element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addInteger(element);
                }
                this.endArray();
            }
        }

        protected final void writeLongArray(@NotNull long[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (long element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addLong(element);
                }
                this.endArray();
            }
        }

        protected final void writeFloatArray(@NotNull float[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (float element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addFloat(element);
                }
                this.endArray();
            }
        }

        protected final void writeDoubleArray(@NotNull double[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (double element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addDouble(element);
                }
                this.endArray();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/molap/exporter/parquet/DataFrameWriteSupport$Companion;", "", "()V", "LIST_ELEMENT_NAME", "", "LIST_REPEATED_NAME", "MAP_KEY_NAME", "MAP_REPEATED_NAME", "MAP_VALUE_NAME", "OLD_LIST_REPEATED_NAME", "molap-parquet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

